<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlterarNumeroParcelaAcordo StructType
 * @subpackage Structs
 */
class AlterarNumeroParcelaAcordo extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The IdAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdAcordo;
    /**
     * The Parcelas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAlterarNumeroParcelaAcordoRequest
     */
    public $Parcelas;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for AlterarNumeroParcelaAcordo
     * @uses AlterarNumeroParcelaAcordo::setChaveCliente()
     * @uses AlterarNumeroParcelaAcordo::setIdAcordo()
     * @uses AlterarNumeroParcelaAcordo::setParcelas()
     * @uses AlterarNumeroParcelaAcordo::setToken()
     * @param string $chaveCliente
     * @param int $idAcordo
     * @param \ArrayType\ArrayOfAlterarNumeroParcelaAcordoRequest $parcelas
     * @param string $token
     */
    public function __construct($chaveCliente = null, $idAcordo = null, \ArrayType\ArrayOfAlterarNumeroParcelaAcordoRequest $parcelas = null, $token = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setIdAcordo($idAcordo)
            ->setParcelas($parcelas)
            ->setToken($token);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\AlterarNumeroParcelaAcordo
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get IdAcordo value
     * @return int|null
     */
    public function getIdAcordo()
    {
        return $this->IdAcordo;
    }
    /**
     * Set IdAcordo value
     * @param int $idAcordo
     * @return \StructType\AlterarNumeroParcelaAcordo
     */
    public function setIdAcordo($idAcordo = null)
    {
        // validation for constraint: int
        if (!is_null($idAcordo) && !(is_int($idAcordo) || ctype_digit($idAcordo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idAcordo, true), gettype($idAcordo)), __LINE__);
        }
        $this->IdAcordo = $idAcordo;
        return $this;
    }
    /**
     * Get Parcelas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAlterarNumeroParcelaAcordoRequest|null
     */
    public function getParcelas()
    {
        return isset($this->Parcelas) ? $this->Parcelas : null;
    }
    /**
     * Set Parcelas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAlterarNumeroParcelaAcordoRequest $parcelas
     * @return \StructType\AlterarNumeroParcelaAcordo
     */
    public function setParcelas(\ArrayType\ArrayOfAlterarNumeroParcelaAcordoRequest $parcelas = null)
    {
        if (is_null($parcelas) || (is_array($parcelas) && empty($parcelas))) {
            unset($this->Parcelas);
        } else {
            $this->Parcelas = $parcelas;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\AlterarNumeroParcelaAcordo
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
