<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcordoType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AcordoType
 * @subpackage Structs
 */
class AcordoType extends AbstractStructBase
{
    /**
     * The DataEmissao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataEmissao;
    /**
     * The DataEntrada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataEntrada;
    /**
     * The NumeroAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroAcordo;
    /**
     * The NumeroParcelas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroParcelas;
    /**
     * The TotalAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalAcordo;
    /**
     * The ValorCorrecao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorCorrecao;
    /**
     * The ValorDesconto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorDesconto;
    /**
     * The ValorDespesa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorDespesa;
    /**
     * The ValorEntrada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorEntrada;
    /**
     * The ValorHonorario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorHonorario;
    /**
     * The ValorJuros
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorJuros;
    /**
     * The ValorMulta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorMulta;
    /**
     * The ValorPrincipal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorPrincipal;
    /**
     * The ValorReceita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorReceita;
    /**
     * The ValorTaxaParcelamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorTaxaParcelamento;
    /**
     * Constructor method for AcordoType
     * @uses AcordoType::setDataEmissao()
     * @uses AcordoType::setDataEntrada()
     * @uses AcordoType::setNumeroAcordo()
     * @uses AcordoType::setNumeroParcelas()
     * @uses AcordoType::setTotalAcordo()
     * @uses AcordoType::setValorCorrecao()
     * @uses AcordoType::setValorDesconto()
     * @uses AcordoType::setValorDespesa()
     * @uses AcordoType::setValorEntrada()
     * @uses AcordoType::setValorHonorario()
     * @uses AcordoType::setValorJuros()
     * @uses AcordoType::setValorMulta()
     * @uses AcordoType::setValorPrincipal()
     * @uses AcordoType::setValorReceita()
     * @uses AcordoType::setValorTaxaParcelamento()
     * @param string $dataEmissao
     * @param string $dataEntrada
     * @param int $numeroAcordo
     * @param int $numeroParcelas
     * @param float $totalAcordo
     * @param float $valorCorrecao
     * @param float $valorDesconto
     * @param float $valorDespesa
     * @param float $valorEntrada
     * @param float $valorHonorario
     * @param float $valorJuros
     * @param float $valorMulta
     * @param float $valorPrincipal
     * @param float $valorReceita
     * @param float $valorTaxaParcelamento
     */
    public function __construct($dataEmissao = null, $dataEntrada = null, $numeroAcordo = null, $numeroParcelas = null, $totalAcordo = null, $valorCorrecao = null, $valorDesconto = null, $valorDespesa = null, $valorEntrada = null, $valorHonorario = null, $valorJuros = null, $valorMulta = null, $valorPrincipal = null, $valorReceita = null, $valorTaxaParcelamento = null)
    {
        $this
            ->setDataEmissao($dataEmissao)
            ->setDataEntrada($dataEntrada)
            ->setNumeroAcordo($numeroAcordo)
            ->setNumeroParcelas($numeroParcelas)
            ->setTotalAcordo($totalAcordo)
            ->setValorCorrecao($valorCorrecao)
            ->setValorDesconto($valorDesconto)
            ->setValorDespesa($valorDespesa)
            ->setValorEntrada($valorEntrada)
            ->setValorHonorario($valorHonorario)
            ->setValorJuros($valorJuros)
            ->setValorMulta($valorMulta)
            ->setValorPrincipal($valorPrincipal)
            ->setValorReceita($valorReceita)
            ->setValorTaxaParcelamento($valorTaxaParcelamento);
    }
    /**
     * Get DataEmissao value
     * @return string|null
     */
    public function getDataEmissao()
    {
        return $this->DataEmissao;
    }
    /**
     * Set DataEmissao value
     * @param string $dataEmissao
     * @return \StructType\AcordoType
     */
    public function setDataEmissao($dataEmissao = null)
    {
        // validation for constraint: string
        if (!is_null($dataEmissao) && !is_string($dataEmissao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataEmissao, true), gettype($dataEmissao)), __LINE__);
        }
        $this->DataEmissao = $dataEmissao;
        return $this;
    }
    /**
     * Get DataEntrada value
     * @return string|null
     */
    public function getDataEntrada()
    {
        return $this->DataEntrada;
    }
    /**
     * Set DataEntrada value
     * @param string $dataEntrada
     * @return \StructType\AcordoType
     */
    public function setDataEntrada($dataEntrada = null)
    {
        // validation for constraint: string
        if (!is_null($dataEntrada) && !is_string($dataEntrada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataEntrada, true), gettype($dataEntrada)), __LINE__);
        }
        $this->DataEntrada = $dataEntrada;
        return $this;
    }
    /**
     * Get NumeroAcordo value
     * @return int|null
     */
    public function getNumeroAcordo()
    {
        return $this->NumeroAcordo;
    }
    /**
     * Set NumeroAcordo value
     * @param int $numeroAcordo
     * @return \StructType\AcordoType
     */
    public function setNumeroAcordo($numeroAcordo = null)
    {
        // validation for constraint: int
        if (!is_null($numeroAcordo) && !(is_int($numeroAcordo) || ctype_digit($numeroAcordo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroAcordo, true), gettype($numeroAcordo)), __LINE__);
        }
        $this->NumeroAcordo = $numeroAcordo;
        return $this;
    }
    /**
     * Get NumeroParcelas value
     * @return int|null
     */
    public function getNumeroParcelas()
    {
        return $this->NumeroParcelas;
    }
    /**
     * Set NumeroParcelas value
     * @param int $numeroParcelas
     * @return \StructType\AcordoType
     */
    public function setNumeroParcelas($numeroParcelas = null)
    {
        // validation for constraint: int
        if (!is_null($numeroParcelas) && !(is_int($numeroParcelas) || ctype_digit($numeroParcelas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroParcelas, true), gettype($numeroParcelas)), __LINE__);
        }
        $this->NumeroParcelas = $numeroParcelas;
        return $this;
    }
    /**
     * Get TotalAcordo value
     * @return float|null
     */
    public function getTotalAcordo()
    {
        return $this->TotalAcordo;
    }
    /**
     * Set TotalAcordo value
     * @param float $totalAcordo
     * @return \StructType\AcordoType
     */
    public function setTotalAcordo($totalAcordo = null)
    {
        // validation for constraint: float
        if (!is_null($totalAcordo) && !(is_float($totalAcordo) || is_numeric($totalAcordo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAcordo, true), gettype($totalAcordo)), __LINE__);
        }
        $this->TotalAcordo = $totalAcordo;
        return $this;
    }
    /**
     * Get ValorCorrecao value
     * @return float|null
     */
    public function getValorCorrecao()
    {
        return $this->ValorCorrecao;
    }
    /**
     * Set ValorCorrecao value
     * @param float $valorCorrecao
     * @return \StructType\AcordoType
     */
    public function setValorCorrecao($valorCorrecao = null)
    {
        // validation for constraint: float
        if (!is_null($valorCorrecao) && !(is_float($valorCorrecao) || is_numeric($valorCorrecao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorCorrecao, true), gettype($valorCorrecao)), __LINE__);
        }
        $this->ValorCorrecao = $valorCorrecao;
        return $this;
    }
    /**
     * Get ValorDesconto value
     * @return float|null
     */
    public function getValorDesconto()
    {
        return $this->ValorDesconto;
    }
    /**
     * Set ValorDesconto value
     * @param float $valorDesconto
     * @return \StructType\AcordoType
     */
    public function setValorDesconto($valorDesconto = null)
    {
        // validation for constraint: float
        if (!is_null($valorDesconto) && !(is_float($valorDesconto) || is_numeric($valorDesconto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorDesconto, true), gettype($valorDesconto)), __LINE__);
        }
        $this->ValorDesconto = $valorDesconto;
        return $this;
    }
    /**
     * Get ValorDespesa value
     * @return float|null
     */
    public function getValorDespesa()
    {
        return $this->ValorDespesa;
    }
    /**
     * Set ValorDespesa value
     * @param float $valorDespesa
     * @return \StructType\AcordoType
     */
    public function setValorDespesa($valorDespesa = null)
    {
        // validation for constraint: float
        if (!is_null($valorDespesa) && !(is_float($valorDespesa) || is_numeric($valorDespesa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorDespesa, true), gettype($valorDespesa)), __LINE__);
        }
        $this->ValorDespesa = $valorDespesa;
        return $this;
    }
    /**
     * Get ValorEntrada value
     * @return float|null
     */
    public function getValorEntrada()
    {
        return $this->ValorEntrada;
    }
    /**
     * Set ValorEntrada value
     * @param float $valorEntrada
     * @return \StructType\AcordoType
     */
    public function setValorEntrada($valorEntrada = null)
    {
        // validation for constraint: float
        if (!is_null($valorEntrada) && !(is_float($valorEntrada) || is_numeric($valorEntrada))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorEntrada, true), gettype($valorEntrada)), __LINE__);
        }
        $this->ValorEntrada = $valorEntrada;
        return $this;
    }
    /**
     * Get ValorHonorario value
     * @return float|null
     */
    public function getValorHonorario()
    {
        return $this->ValorHonorario;
    }
    /**
     * Set ValorHonorario value
     * @param float $valorHonorario
     * @return \StructType\AcordoType
     */
    public function setValorHonorario($valorHonorario = null)
    {
        // validation for constraint: float
        if (!is_null($valorHonorario) && !(is_float($valorHonorario) || is_numeric($valorHonorario))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorHonorario, true), gettype($valorHonorario)), __LINE__);
        }
        $this->ValorHonorario = $valorHonorario;
        return $this;
    }
    /**
     * Get ValorJuros value
     * @return float|null
     */
    public function getValorJuros()
    {
        return $this->ValorJuros;
    }
    /**
     * Set ValorJuros value
     * @param float $valorJuros
     * @return \StructType\AcordoType
     */
    public function setValorJuros($valorJuros = null)
    {
        // validation for constraint: float
        if (!is_null($valorJuros) && !(is_float($valorJuros) || is_numeric($valorJuros))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorJuros, true), gettype($valorJuros)), __LINE__);
        }
        $this->ValorJuros = $valorJuros;
        return $this;
    }
    /**
     * Get ValorMulta value
     * @return float|null
     */
    public function getValorMulta()
    {
        return $this->ValorMulta;
    }
    /**
     * Set ValorMulta value
     * @param float $valorMulta
     * @return \StructType\AcordoType
     */
    public function setValorMulta($valorMulta = null)
    {
        // validation for constraint: float
        if (!is_null($valorMulta) && !(is_float($valorMulta) || is_numeric($valorMulta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorMulta, true), gettype($valorMulta)), __LINE__);
        }
        $this->ValorMulta = $valorMulta;
        return $this;
    }
    /**
     * Get ValorPrincipal value
     * @return float|null
     */
    public function getValorPrincipal()
    {
        return $this->ValorPrincipal;
    }
    /**
     * Set ValorPrincipal value
     * @param float $valorPrincipal
     * @return \StructType\AcordoType
     */
    public function setValorPrincipal($valorPrincipal = null)
    {
        // validation for constraint: float
        if (!is_null($valorPrincipal) && !(is_float($valorPrincipal) || is_numeric($valorPrincipal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorPrincipal, true), gettype($valorPrincipal)), __LINE__);
        }
        $this->ValorPrincipal = $valorPrincipal;
        return $this;
    }
    /**
     * Get ValorReceita value
     * @return float|null
     */
    public function getValorReceita()
    {
        return $this->ValorReceita;
    }
    /**
     * Set ValorReceita value
     * @param float $valorReceita
     * @return \StructType\AcordoType
     */
    public function setValorReceita($valorReceita = null)
    {
        // validation for constraint: float
        if (!is_null($valorReceita) && !(is_float($valorReceita) || is_numeric($valorReceita))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorReceita, true), gettype($valorReceita)), __LINE__);
        }
        $this->ValorReceita = $valorReceita;
        return $this;
    }
    /**
     * Get ValorTaxaParcelamento value
     * @return float|null
     */
    public function getValorTaxaParcelamento()
    {
        return $this->ValorTaxaParcelamento;
    }
    /**
     * Set ValorTaxaParcelamento value
     * @param float $valorTaxaParcelamento
     * @return \StructType\AcordoType
     */
    public function setValorTaxaParcelamento($valorTaxaParcelamento = null)
    {
        // validation for constraint: float
        if (!is_null($valorTaxaParcelamento) && !(is_float($valorTaxaParcelamento) || is_numeric($valorTaxaParcelamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorTaxaParcelamento, true), gettype($valorTaxaParcelamento)), __LINE__);
        }
        $this->ValorTaxaParcelamento = $valorTaxaParcelamento;
        return $this;
    }
}
