<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcordoResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AcordoResponse
 * @subpackage Structs
 */
class AcordoResponse extends AcordoType
{
    /**
     * The Credor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Credor;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IdCredor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCredor;
    /**
     * The IdCriptografado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdCriptografado;
    /**
     * The ParcelasAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaAcordoResponse
     */
    public $ParcelasAcordo;
    /**
     * The ParcelasOriginais
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaOriginalResponse
     */
    public $ParcelasOriginais;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TipoPagamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipoPagamento;
    /**
     * Constructor method for AcordoResponse
     * @uses AcordoResponse::setCredor()
     * @uses AcordoResponse::setId()
     * @uses AcordoResponse::setIdCredor()
     * @uses AcordoResponse::setIdCriptografado()
     * @uses AcordoResponse::setParcelasAcordo()
     * @uses AcordoResponse::setParcelasOriginais()
     * @uses AcordoResponse::setStatus()
     * @uses AcordoResponse::setTipoPagamento()
     * @param string $credor
     * @param int $id
     * @param int $idCredor
     * @param string $idCriptografado
     * @param \ArrayType\ArrayOfParcelaAcordoResponse $parcelasAcordo
     * @param \ArrayType\ArrayOfParcelaOriginalResponse $parcelasOriginais
     * @param string $status
     * @param int $tipoPagamento
     */
    public function __construct($credor = null, $id = null, $idCredor = null, $idCriptografado = null, \ArrayType\ArrayOfParcelaAcordoResponse $parcelasAcordo = null, \ArrayType\ArrayOfParcelaOriginalResponse $parcelasOriginais = null, $status = null, $tipoPagamento = null)
    {
        $this
            ->setCredor($credor)
            ->setId($id)
            ->setIdCredor($idCredor)
            ->setIdCriptografado($idCriptografado)
            ->setParcelasAcordo($parcelasAcordo)
            ->setParcelasOriginais($parcelasOriginais)
            ->setStatus($status)
            ->setTipoPagamento($tipoPagamento);
    }
    /**
     * Get Credor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCredor()
    {
        return isset($this->Credor) ? $this->Credor : null;
    }
    /**
     * Set Credor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $credor
     * @return \StructType\AcordoResponse
     */
    public function setCredor($credor = null)
    {
        // validation for constraint: string
        if (!is_null($credor) && !is_string($credor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credor, true), gettype($credor)), __LINE__);
        }
        if (is_null($credor) || (is_array($credor) && empty($credor))) {
            unset($this->Credor);
        } else {
            $this->Credor = $credor;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\AcordoResponse
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IdCredor value
     * @return int|null
     */
    public function getIdCredor()
    {
        return $this->IdCredor;
    }
    /**
     * Set IdCredor value
     * @param int $idCredor
     * @return \StructType\AcordoResponse
     */
    public function setIdCredor($idCredor = null)
    {
        // validation for constraint: int
        if (!is_null($idCredor) && !(is_int($idCredor) || ctype_digit($idCredor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCredor, true), gettype($idCredor)), __LINE__);
        }
        $this->IdCredor = $idCredor;
        return $this;
    }
    /**
     * Get IdCriptografado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdCriptografado()
    {
        return isset($this->IdCriptografado) ? $this->IdCriptografado : null;
    }
    /**
     * Set IdCriptografado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idCriptografado
     * @return \StructType\AcordoResponse
     */
    public function setIdCriptografado($idCriptografado = null)
    {
        // validation for constraint: string
        if (!is_null($idCriptografado) && !is_string($idCriptografado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idCriptografado, true), gettype($idCriptografado)), __LINE__);
        }
        if (is_null($idCriptografado) || (is_array($idCriptografado) && empty($idCriptografado))) {
            unset($this->IdCriptografado);
        } else {
            $this->IdCriptografado = $idCriptografado;
        }
        return $this;
    }
    /**
     * Get ParcelasAcordo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaAcordoResponse|null
     */
    public function getParcelasAcordo()
    {
        return isset($this->ParcelasAcordo) ? $this->ParcelasAcordo : null;
    }
    /**
     * Set ParcelasAcordo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaAcordoResponse $parcelasAcordo
     * @return \StructType\AcordoResponse
     */
    public function setParcelasAcordo(\ArrayType\ArrayOfParcelaAcordoResponse $parcelasAcordo = null)
    {
        if (is_null($parcelasAcordo) || (is_array($parcelasAcordo) && empty($parcelasAcordo))) {
            unset($this->ParcelasAcordo);
        } else {
            $this->ParcelasAcordo = $parcelasAcordo;
        }
        return $this;
    }
    /**
     * Get ParcelasOriginais value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaOriginalResponse|null
     */
    public function getParcelasOriginais()
    {
        return isset($this->ParcelasOriginais) ? $this->ParcelasOriginais : null;
    }
    /**
     * Set ParcelasOriginais value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaOriginalResponse $parcelasOriginais
     * @return \StructType\AcordoResponse
     */
    public function setParcelasOriginais(\ArrayType\ArrayOfParcelaOriginalResponse $parcelasOriginais = null)
    {
        if (is_null($parcelasOriginais) || (is_array($parcelasOriginais) && empty($parcelasOriginais))) {
            unset($this->ParcelasOriginais);
        } else {
            $this->ParcelasOriginais = $parcelasOriginais;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\AcordoResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TipoPagamento value
     * @return int|null
     */
    public function getTipoPagamento()
    {
        return $this->TipoPagamento;
    }
    /**
     * Set TipoPagamento value
     * @param int $tipoPagamento
     * @return \StructType\AcordoResponse
     */
    public function setTipoPagamento($tipoPagamento = null)
    {
        // validation for constraint: int
        if (!is_null($tipoPagamento) && !(is_int($tipoPagamento) || ctype_digit($tipoPagamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoPagamento, true), gettype($tipoPagamento)), __LINE__);
        }
        $this->TipoPagamento = $tipoPagamento;
        return $this;
    }
}
