<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcordoQuebraResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AcordoQuebraResponse
 * @subpackage Structs
 */
class AcordoQuebraResponse extends AbstractStructBase
{
    /**
     * The Automatica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Automatica;
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The NumeroAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroAcordo;
    /**
     * Constructor method for AcordoQuebraResponse
     * @uses AcordoQuebraResponse::setAutomatica()
     * @uses AcordoQuebraResponse::setChaveCliente()
     * @uses AcordoQuebraResponse::setNumeroAcordo()
     * @param bool $automatica
     * @param string $chaveCliente
     * @param int $numeroAcordo
     */
    public function __construct($automatica = null, $chaveCliente = null, $numeroAcordo = null)
    {
        $this
            ->setAutomatica($automatica)
            ->setChaveCliente($chaveCliente)
            ->setNumeroAcordo($numeroAcordo);
    }
    /**
     * Get Automatica value
     * @return bool|null
     */
    public function getAutomatica()
    {
        return $this->Automatica;
    }
    /**
     * Set Automatica value
     * @param bool $automatica
     * @return \StructType\AcordoQuebraResponse
     */
    public function setAutomatica($automatica = null)
    {
        // validation for constraint: boolean
        if (!is_null($automatica) && !is_bool($automatica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automatica, true), gettype($automatica)), __LINE__);
        }
        $this->Automatica = $automatica;
        return $this;
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\AcordoQuebraResponse
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get NumeroAcordo value
     * @return int|null
     */
    public function getNumeroAcordo()
    {
        return $this->NumeroAcordo;
    }
    /**
     * Set NumeroAcordo value
     * @param int $numeroAcordo
     * @return \StructType\AcordoQuebraResponse
     */
    public function setNumeroAcordo($numeroAcordo = null)
    {
        // validation for constraint: int
        if (!is_null($numeroAcordo) && !(is_int($numeroAcordo) || ctype_digit($numeroAcordo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroAcordo, true), gettype($numeroAcordo)), __LINE__);
        }
        $this->NumeroAcordo = $numeroAcordo;
        return $this;
    }
}
