<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Recuperar ServiceType
 * @subpackage Services
 */
class Recuperar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RecuperarPlanosPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecuperarPlanosPortal $parameters
     * @return \StructType\RecuperarPlanosPortalResponse|bool
     */
    public function RecuperarPlanosPortal(\StructType\RecuperarPlanosPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecuperarPlanosPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RecuperarBinsElo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecuperarBinsElo $parameters
     * @return \StructType\RecuperarBinsEloResponse|bool
     */
    public function RecuperarBinsElo(\StructType\RecuperarBinsElo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RecuperarBinsElo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RecuperarBinsEloResponse|\StructType\RecuperarPlanosPortalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
