<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reabrir ServiceType
 * @subpackage Services
 */
class Reabrir extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReabrirContrato
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReabrirContrato $parameters
     * @return \StructType\ReabrirContratoResponse|bool
     */
    public function ReabrirContrato(\StructType\ReabrirContrato $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReabrirContrato($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReabrirContratoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
