<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Grava ServiceType
 * @subpackage Services
 */
class Grava extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GravaLogPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GravaLogPortal $parameters
     * @return \StructType\GravaLogPortalResponse|bool
     */
    public function GravaLogPortal(\StructType\GravaLogPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GravaLogPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GravaLogPortalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
