<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetToken $parameters
     * @return \StructType\GetTokenResponse|bool
     */
    public function GetToken(\StructType\GetToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCartaoParametrosIntegracao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCartaoParametrosIntegracao $parameters
     * @return \StructType\GetCartaoParametrosIntegracaoResponse|bool
     */
    public function GetCartaoParametrosIntegracao(\StructType\GetCartaoParametrosIntegracao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCartaoParametrosIntegracao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCartaoParametrosIntegracaoPorId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCartaoParametrosIntegracaoPorId $parameters
     * @return \StructType\GetCartaoParametrosIntegracaoPorIdResponse|bool
     */
    public function GetCartaoParametrosIntegracaoPorId(\StructType\GetCartaoParametrosIntegracaoPorId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCartaoParametrosIntegracaoPorId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConfigCredor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConfigCredor $parameters
     * @return \StructType\GetConfigCredorResponse|bool
     */
    public function GetConfigCredor(\StructType\GetConfigCredor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetConfigCredor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCartaoParametrosIntegracaoPorIdResponse|\StructType\GetCartaoParametrosIntegracaoResponse|\StructType\GetConfigCredorResponse|\StructType\GetTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
