<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gerar ServiceType
 * @subpackage Services
 */
class Gerar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GerarAcordoCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GerarAcordoCobChat $parameters
     * @return \StructType\GerarAcordoCobChatResponse|bool
     */
    public function GerarAcordoCobChat(\StructType\GerarAcordoCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GerarAcordoCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GerarAcordoUra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GerarAcordoUra $parameters
     * @return \StructType\GerarAcordoUraResponse|bool
     */
    public function GerarAcordoUra(\StructType\GerarAcordoUra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GerarAcordoUra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GerarAcordoPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GerarAcordoPortal $parameters
     * @return \StructType\GerarAcordoPortalResponse|bool
     */
    public function GerarAcordoPortal(\StructType\GerarAcordoPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GerarAcordoPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GerarAcordoCobChatResponse|\StructType\GerarAcordoPortalResponse|\StructType\GerarAcordoUraResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
