<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Envia ServiceType
 * @subpackage Services
 */
class Envia extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EnviaBoletoCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviaBoletoCobChat $parameters
     * @return \StructType\EnviaBoletoCobChatResponse|bool
     */
    public function EnviaBoletoCobChat(\StructType\EnviaBoletoCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviaBoletoCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviaCheckoutUra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviaCheckoutUra $parameters
     * @return \StructType\EnviaCheckoutUraResponse|bool
     */
    public function EnviaCheckoutUra(\StructType\EnviaCheckoutUra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviaCheckoutUra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviaBoletoUra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviaBoletoUra $parameters
     * @return \StructType\EnviaBoletoUraResponse|bool
     */
    public function EnviaBoletoUra(\StructType\EnviaBoletoUra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviaBoletoUra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviaBoletoTermoUra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviaBoletoTermoUra $parameters
     * @return \StructType\EnviaBoletoTermoUraResponse|bool
     */
    public function EnviaBoletoTermoUra(\StructType\EnviaBoletoTermoUra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviaBoletoTermoUra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviaCodigoAcessoCobchat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviaCodigoAcessoCobchat $parameters
     * @return \StructType\EnviaCodigoAcessoCobchatResponse|bool
     */
    public function EnviaCodigoAcessoCobchat(\StructType\EnviaCodigoAcessoCobchat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviaCodigoAcessoCobchat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviaCheckoutCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviaCheckoutCobChat $parameters
     * @return \StructType\EnviaCheckoutCobChatResponse|bool
     */
    public function EnviaCheckoutCobChat(\StructType\EnviaCheckoutCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviaCheckoutCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviaPixCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviaPixCobChat $parameters
     * @return \StructType\EnviaPixCobChatResponse|bool
     */
    public function EnviaPixCobChat(\StructType\EnviaPixCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviaPixCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviaBoleto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviaBoleto $parameters
     * @return \StructType\EnviaBoletoResponse|bool
     */
    public function EnviaBoleto(\StructType\EnviaBoleto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviaBoleto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviaCodigoViaSMS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviaCodigoViaSMS $parameters
     * @return \StructType\EnviaCodigoViaSMSResponse|bool
     */
    public function EnviaCodigoViaSMS(\StructType\EnviaCodigoViaSMS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviaCodigoViaSMS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EnviaCodigoViaEmail
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviaCodigoViaEmail $parameters
     * @return \StructType\EnviaCodigoViaEmailResponse|bool
     */
    public function EnviaCodigoViaEmail(\StructType\EnviaCodigoViaEmail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EnviaCodigoViaEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EnviaBoletoCobChatResponse|\StructType\EnviaBoletoResponse|\StructType\EnviaBoletoTermoUraResponse|\StructType\EnviaBoletoUraResponse|\StructType\EnviaCheckoutCobChatResponse|\StructType\EnviaCheckoutUraResponse|\StructType\EnviaCodigoAcessoCobchatResponse|\StructType\EnviaCodigoViaEmailResponse|\StructType\EnviaCodigoViaSMSResponse|\StructType\EnviaPixCobChatResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
