<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emitir ServiceType
 * @subpackage Services
 */
class Emitir extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EmitirBoletoUra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirBoletoUra $parameters
     * @return \StructType\EmitirBoletoUraResponse|bool
     */
    public function EmitirBoletoUra(\StructType\EmitirBoletoUra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirBoletoUra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmitirBoleto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirBoleto $parameters
     * @return \StructType\EmitirBoletoResponse|bool
     */
    public function EmitirBoleto(\StructType\EmitirBoleto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirBoleto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmitirBoletoCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirBoletoCobChat $parameters
     * @return \StructType\EmitirBoletoCobChatResponse|bool
     */
    public function EmitirBoletoCobChat(\StructType\EmitirBoletoCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirBoletoCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmitirBoletoPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirBoletoPortal $parameters
     * @return \StructType\EmitirBoletoPortalResponse|bool
     */
    public function EmitirBoletoPortal(\StructType\EmitirBoletoPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirBoletoPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmitirBoletoPortalV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirBoletoPortalV2 $parameters
     * @return \StructType\EmitirBoletoPortalV2Response|bool
     */
    public function EmitirBoletoPortalV2(\StructType\EmitirBoletoPortalV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirBoletoPortalV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmitirBoletoApi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirBoletoApi $parameters
     * @return \StructType\EmitirBoletoApiResponse|bool
     */
    public function EmitirBoletoApi(\StructType\EmitirBoletoApi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirBoletoApi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmitirBoleto2ViaApi
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirBoleto2ViaApi $parameters
     * @return \StructType\EmitirBoleto2ViaApiResponse|bool
     */
    public function EmitirBoleto2ViaApi(\StructType\EmitirBoleto2ViaApi $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirBoleto2ViaApi($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EmitirBoleto2ViaApiResponse|\StructType\EmitirBoletoApiResponse|\StructType\EmitirBoletoCobChatResponse|\StructType\EmitirBoletoPortalResponse|\StructType\EmitirBoletoPortalV2Response|\StructType\EmitirBoletoResponse|\StructType\EmitirBoletoUraResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
