<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consultar ServiceType
 * @subpackage Services
 */
class Consultar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultarContratosSemNumeroPasta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarContratosSemNumeroPasta $parameters
     * @return \StructType\ConsultarContratosSemNumeroPastaResponse|bool
     */
    public function ConsultarContratosSemNumeroPasta(\StructType\ConsultarContratosSemNumeroPasta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarContratosSemNumeroPasta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarClientePorCPFCNPJUra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarClientePorCPFCNPJUra $parameters
     * @return \StructType\ConsultarClientePorCPFCNPJUraResponse|bool
     */
    public function ConsultarClientePorCPFCNPJUra(\StructType\ConsultarClientePorCPFCNPJUra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarClientePorCPFCNPJUra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarCredoresDoClienteUra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarCredoresDoClienteUra $parameters
     * @return \StructType\ConsultarCredoresDoClienteUraResponse|bool
     */
    public function ConsultarCredoresDoClienteUra(\StructType\ConsultarCredoresDoClienteUra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarCredoresDoClienteUra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarContratoClienteUra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarContratoClienteUra $parameters
     * @return \StructType\ConsultarContratoClienteUraResponse|bool
     */
    public function ConsultarContratoClienteUra(\StructType\ConsultarContratoClienteUra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarContratoClienteUra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarFormaPagamentoUra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarFormaPagamentoUra $parameters
     * @return \StructType\ConsultarFormaPagamentoUraResponse|bool
     */
    public function ConsultarFormaPagamentoUra(\StructType\ConsultarFormaPagamentoUra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarFormaPagamentoUra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarDadosClienteCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarDadosClienteCobChat $parameters
     * @return \StructType\ConsultarDadosClienteCobChatResponse|bool
     */
    public function ConsultarDadosClienteCobChat(\StructType\ConsultarDadosClienteCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarDadosClienteCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarAssessoriaPorURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAssessoriaPorURL $parameters
     * @return \StructType\ConsultarAssessoriaPorURLResponse|bool
     */
    public function ConsultarAssessoriaPorURL(\StructType\ConsultarAssessoriaPorURL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAssessoriaPorURL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarDadosPix
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarDadosPix $parameters
     * @return \StructType\ConsultarDadosPixResponse|bool
     */
    public function ConsultarDadosPix(\StructType\ConsultarDadosPix $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarDadosPix($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarAssessoriaPorURLCheckout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAssessoriaPorURLCheckout $parameters
     * @return \StructType\ConsultarAssessoriaPorURLCheckoutResponse|bool
     */
    public function ConsultarAssessoriaPorURLCheckout(\StructType\ConsultarAssessoriaPorURLCheckout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAssessoriaPorURLCheckout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarAssessoriaPorAcordo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAssessoriaPorAcordo $parameters
     * @return \StructType\ConsultarAssessoriaPorAcordoResponse|bool
     */
    public function ConsultarAssessoriaPorAcordo(\StructType\ConsultarAssessoriaPorAcordo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAssessoriaPorAcordo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarAssessoriaPorPixCheckout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAssessoriaPorPixCheckout $parameters
     * @return \StructType\ConsultarAssessoriaPorPixCheckoutResponse|bool
     */
    public function ConsultarAssessoriaPorPixCheckout(\StructType\ConsultarAssessoriaPorPixCheckout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAssessoriaPorPixCheckout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarPortalIntegracao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarPortalIntegracao $parameters
     * @return \StructType\ConsultarPortalIntegracaoResponse|bool
     */
    public function ConsultarPortalIntegracao(\StructType\ConsultarPortalIntegracao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarPortalIntegracao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarPortalParametro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarPortalParametro $parameters
     * @return \StructType\ConsultarPortalParametroResponse|bool
     */
    public function ConsultarPortalParametro(\StructType\ConsultarPortalParametro $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarPortalParametro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarCredoresDoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarCredoresDoCliente $parameters
     * @return \StructType\ConsultarCredoresDoClienteResponse|bool
     */
    public function ConsultarCredoresDoCliente(\StructType\ConsultarCredoresDoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarCredoresDoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarContratoCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarContratoCliente $parameters
     * @return \StructType\ConsultarContratoClienteResponse|bool
     */
    public function ConsultarContratoCliente(\StructType\ConsultarContratoCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarContratoCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarContratoCampoPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarContratoCampoPortal $parameters
     * @return \StructType\ConsultarContratoCampoPortalResponse|bool
     */
    public function ConsultarContratoCampoPortal(\StructType\ConsultarContratoCampoPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarContratoCampoPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultarAcordosEmAndamentoPorCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAcordosEmAndamentoPorCliente $parameters
     * @return \StructType\ConsultarAcordosEmAndamentoPorClienteResponse|bool
     */
    public function ConsultarAcordosEmAndamentoPorCliente(\StructType\ConsultarAcordosEmAndamentoPorCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAcordosEmAndamentoPorCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultarAcordosEmAndamentoPorClientePortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAcordosEmAndamentoPorClientePortal $parameters
     * @return \StructType\ConsultarAcordosEmAndamentoPorClientePortalResponse|bool
     */
    public function ConsultarAcordosEmAndamentoPorClientePortal(\StructType\ConsultarAcordosEmAndamentoPorClientePortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAcordosEmAndamentoPorClientePortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultarAcordosFinalizadosPorCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAcordosFinalizadosPorCliente $parameters
     * @return \StructType\ConsultarAcordosFinalizadosPorClienteResponse|bool
     */
    public function ConsultarAcordosFinalizadosPorCliente(\StructType\ConsultarAcordosFinalizadosPorCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAcordosFinalizadosPorCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultarAcordosFinalizadosPorClientePortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAcordosFinalizadosPorClientePortal $parameters
     * @return \StructType\ConsultarAcordosFinalizadosPorClientePortalResponse|bool
     */
    public function ConsultarAcordosFinalizadosPorClientePortal(\StructType\ConsultarAcordosFinalizadosPorClientePortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAcordosFinalizadosPorClientePortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultarAcordosEmAndamentoPorCPFCNPJ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAcordosEmAndamentoPorCPFCNPJ $parameters
     * @return \StructType\ConsultarAcordosEmAndamentoPorCPFCNPJResponse|bool
     */
    public function ConsultarAcordosEmAndamentoPorCPFCNPJ(\StructType\ConsultarAcordosEmAndamentoPorCPFCNPJ $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAcordosEmAndamentoPorCPFCNPJ($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultarAcordosFinalizadosPorCPFCNPJ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAcordosFinalizadosPorCPFCNPJ $parameters
     * @return \StructType\ConsultarAcordosFinalizadosPorCPFCNPJResponse|bool
     */
    public function ConsultarAcordosFinalizadosPorCPFCNPJ(\StructType\ConsultarAcordosFinalizadosPorCPFCNPJ $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAcordosFinalizadosPorCPFCNPJ($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultarTodosAcordosPorClientePortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarTodosAcordosPorClientePortal $parameters
     * @return \StructType\ConsultarTodosAcordosPorClientePortalResponse|bool
     */
    public function ConsultarTodosAcordosPorClientePortal(\StructType\ConsultarTodosAcordosPorClientePortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarTodosAcordosPorClientePortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarClientePortalPorCPFCNPJ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarClientePortalPorCPFCNPJ $parameters
     * @return \StructType\ConsultarClientePortalPorCPFCNPJResponse|bool
     */
    public function ConsultarClientePortalPorCPFCNPJ(\StructType\ConsultarClientePortalPorCPFCNPJ $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarClientePortalPorCPFCNPJ($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarClientePorCPFCNPJ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarClientePorCPFCNPJ $parameters
     * @return \StructType\ConsultarClientePorCPFCNPJResponse|bool
     */
    public function ConsultarClientePorCPFCNPJ(\StructType\ConsultarClientePorCPFCNPJ $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarClientePorCPFCNPJ($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarClientePorTelefone
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarClientePorTelefone $parameters
     * @return \StructType\ConsultarClientePorTelefoneResponse|bool
     */
    public function ConsultarClientePorTelefone(\StructType\ConsultarClientePorTelefone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarClientePorTelefone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarClienteDiscador
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarClienteDiscador $parameters
     * @return \StructType\ConsultarClienteDiscadorResponse|bool
     */
    public function ConsultarClienteDiscador(\StructType\ConsultarClienteDiscador $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarClienteDiscador($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarCliente $parameters
     * @return \StructType\ConsultarClienteResponse|bool
     */
    public function ConsultarCliente(\StructType\ConsultarCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarClientes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarClientes $parameters
     * @return \StructType\ConsultarClientesResponse|bool
     */
    public function ConsultarClientes(\StructType\ConsultarClientes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarClientes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarContratos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarContratos $parameters
     * @return \StructType\ConsultarContratosResponse|bool
     */
    public function ConsultarContratos(\StructType\ConsultarContratos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarContratos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarAcordos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAcordos $parameters
     * @return \StructType\ConsultarAcordosResponse|bool
     */
    public function ConsultarAcordos(\StructType\ConsultarAcordos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAcordos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarAcordosPorDataAlteracao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAcordosPorDataAlteracao $parameters
     * @return \StructType\ConsultarAcordosPorDataAlteracaoResponse|bool
     */
    public function ConsultarAcordosPorDataAlteracao(\StructType\ConsultarAcordosPorDataAlteracao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAcordosPorDataAlteracao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarEventos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarEventos $parameters
     * @return \StructType\ConsultarEventosResponse|bool
     */
    public function ConsultarEventos(\StructType\ConsultarEventos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarEventos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarPagamentos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarPagamentos $parameters
     * @return \StructType\ConsultarPagamentosResponse|bool
     */
    public function ConsultarPagamentos(\StructType\ConsultarPagamentos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarPagamentos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarPagamentosOperador
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarPagamentosOperador $parameters
     * @return \StructType\ConsultarPagamentosOperadorResponse|bool
     */
    public function ConsultarPagamentosOperador(\StructType\ConsultarPagamentosOperador $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarPagamentosOperador($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarPagamentosRenegociacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarPagamentosRenegociacao $parameters
     * @return \StructType\ConsultarPagamentosRenegociacaoResponse|bool
     */
    public function ConsultarPagamentosRenegociacao(\StructType\ConsultarPagamentosRenegociacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarPagamentosRenegociacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarBoletos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarBoletos $parameters
     * @return \StructType\ConsultarBoletosResponse|bool
     */
    public function ConsultarBoletos(\StructType\ConsultarBoletos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarBoletos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarQuebraAcordos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarQuebraAcordos $parameters
     * @return \StructType\ConsultarQuebraAcordosResponse|bool
     */
    public function ConsultarQuebraAcordos(\StructType\ConsultarQuebraAcordos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarQuebraAcordos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarNossoNumero
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarNossoNumero $parameters
     * @return \StructType\ConsultarNossoNumeroResponse|bool
     */
    public function ConsultarNossoNumero(\StructType\ConsultarNossoNumero $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarNossoNumero($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarAtualizacaoCadastral
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAtualizacaoCadastral $parameters
     * @return \StructType\ConsultarAtualizacaoCadastralResponse|bool
     */
    public function ConsultarAtualizacaoCadastral(\StructType\ConsultarAtualizacaoCadastral $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAtualizacaoCadastral($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarIntegracaoGateway
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarIntegracaoGateway $parameters
     * @return \StructType\ConsultarIntegracaoGatewayResponse|bool
     */
    public function ConsultarIntegracaoGateway(\StructType\ConsultarIntegracaoGateway $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarIntegracaoGateway($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarFormaPagamentoCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarFormaPagamentoCobChat $parameters
     * @return \StructType\ConsultarFormaPagamentoCobChatResponse|bool
     */
    public function ConsultarFormaPagamentoCobChat(\StructType\ConsultarFormaPagamentoCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarFormaPagamentoCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarFiliaisKrotonPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarFiliaisKrotonPortal $parameters
     * @return \StructType\ConsultarFiliaisKrotonPortalResponse|bool
     */
    public function ConsultarFiliaisKrotonPortal(\StructType\ConsultarFiliaisKrotonPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarFiliaisKrotonPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultarFilialKrotonDoContratoPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarFilialKrotonDoContratoPortal $parameters
     * @return \StructType\ConsultarFilialKrotonDoContratoPortalResponse|bool
     */
    public function ConsultarFilialKrotonDoContratoPortal(\StructType\ConsultarFilialKrotonDoContratoPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarFilialKrotonDoContratoPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarIntegracaoCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarIntegracaoCobChat $parameters
     * @return \StructType\ConsultarIntegracaoCobChatResponse|bool
     */
    public function ConsultarIntegracaoCobChat(\StructType\ConsultarIntegracaoCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarIntegracaoCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultarTodosAcordosPorClienteCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarTodosAcordosPorClienteCobChat $parameters
     * @return \StructType\ConsultarTodosAcordosPorClienteCobChatResponse|bool
     */
    public function ConsultarTodosAcordosPorClienteCobChat(\StructType\ConsultarTodosAcordosPorClienteCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarTodosAcordosPorClienteCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ConsultarAcordosEmAndamentoPorClienteCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarAcordosEmAndamentoPorClienteCobChat $parameters
     * @return \StructType\ConsultarAcordosEmAndamentoPorClienteCobChatResponse|bool
     */
    public function ConsultarAcordosEmAndamentoPorClienteCobChat(\StructType\ConsultarAcordosEmAndamentoPorClienteCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarAcordosEmAndamentoPorClienteCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarContratoClienteCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarContratoClienteCobChat $parameters
     * @return \StructType\ConsultarContratoClienteCobChatResponse|bool
     */
    public function ConsultarContratoClienteCobChat(\StructType\ConsultarContratoClienteCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarContratoClienteCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarCredoresDoClienteCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarCredoresDoClienteCobChat $parameters
     * @return \StructType\ConsultarCredoresDoClienteCobChatResponse|bool
     */
    public function ConsultarCredoresDoClienteCobChat(\StructType\ConsultarCredoresDoClienteCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarCredoresDoClienteCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ConsultarClientePorCPFCNPJCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarClientePorCPFCNPJCobChat $parameters
     * @return \StructType\ConsultarClientePorCPFCNPJCobChatResponse|bool
     */
    public function ConsultarClientePorCPFCNPJCobChat(\StructType\ConsultarClientePorCPFCNPJCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarClientePorCPFCNPJCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConsultarAcordosEmAndamentoPorClienteCobChatResponse|\StructType\ConsultarAcordosEmAndamentoPorClientePortalResponse|\StructType\ConsultarAcordosEmAndamentoPorClienteResponse|\StructType\ConsultarAcordosEmAndamentoPorCPFCNPJResponse|\StructType\ConsultarAcordosFinalizadosPorClientePortalResponse|\StructType\ConsultarAcordosFinalizadosPorClienteResponse|\StructType\ConsultarAcordosFinalizadosPorCPFCNPJResponse|\StructType\ConsultarAcordosPorDataAlteracaoResponse|\StructType\ConsultarAcordosResponse|\StructType\ConsultarAssessoriaPorAcordoResponse|\StructType\ConsultarAssessoriaPorPixCheckoutResponse|\StructType\ConsultarAssessoriaPorURLCheckoutResponse|\StructType\ConsultarAssessoriaPorURLResponse|\StructType\ConsultarAtualizacaoCadastralResponse|\StructType\ConsultarBoletosResponse|\StructType\ConsultarClienteDiscadorResponse|\StructType\ConsultarClientePorCPFCNPJCobChatResponse|\StructType\ConsultarClientePorCPFCNPJResponse|\StructType\ConsultarClientePorCPFCNPJUraResponse|\StructType\ConsultarClientePortalPorCPFCNPJResponse|\StructType\ConsultarClientePorTelefoneResponse|\StructType\ConsultarClienteResponse|\StructType\ConsultarClientesResponse|\StructType\ConsultarContratoCampoPortalResponse|\StructType\ConsultarContratoClienteCobChatResponse|\StructType\ConsultarContratoClienteResponse|\StructType\ConsultarContratoClienteUraResponse|\StructType\ConsultarContratosResponse|\StructType\ConsultarContratosSemNumeroPastaResponse|\StructType\ConsultarCredoresDoClienteCobChatResponse|\StructType\ConsultarCredoresDoClienteResponse|\StructType\ConsultarCredoresDoClienteUraResponse|\StructType\ConsultarDadosClienteCobChatResponse|\StructType\ConsultarDadosPixResponse|\StructType\ConsultarEventosResponse|\StructType\ConsultarFiliaisKrotonPortalResponse|\StructType\ConsultarFilialKrotonDoContratoPortalResponse|\StructType\ConsultarFormaPagamentoCobChatResponse|\StructType\ConsultarFormaPagamentoUraResponse|\StructType\ConsultarIntegracaoCobChatResponse|\StructType\ConsultarIntegracaoGatewayResponse|\StructType\ConsultarNossoNumeroResponse|\StructType\ConsultarPagamentosOperadorResponse|\StructType\ConsultarPagamentosRenegociacaoResponse|\StructType\ConsultarPagamentosResponse|\StructType\ConsultarPortalIntegracaoResponse|\StructType\ConsultarPortalParametroResponse|\StructType\ConsultarQuebraAcordosResponse|\StructType\ConsultarTodosAcordosPorClienteCobChatResponse|\StructType\ConsultarTodosAcordosPorClientePortalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
