<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Calculo ServiceType
 * @subpackage Services
 */
class Calculo extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CalculoUra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculoUra $parameters
     * @return \StructType\CalculoUraResponse|bool
     */
    public function CalculoUra(\StructType\CalculoUra $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculoUra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculoPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculoPortal $parameters
     * @return \StructType\CalculoPortalResponse|bool
     */
    public function CalculoPortal(\StructType\CalculoPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculoPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculoCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CalculoCobChat $parameters
     * @return \StructType\CalculoCobChatResponse|bool
     */
    public function CalculoCobChat(\StructType\CalculoCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculoCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CalculoCobChatResponse|\StructType\CalculoPortalResponse|\StructType\CalculoUraResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
