<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProdutoRequest ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfProdutoRequest
 * @subpackage Arrays
 */
class ArrayOfProdutoRequest extends AbstractStructArrayBase
{
    /**
     * The ProdutoRequest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProdutoRequest[]
     */
    public $ProdutoRequest;
    /**
     * Constructor method for ArrayOfProdutoRequest
     * @uses ArrayOfProdutoRequest::setProdutoRequest()
     * @param \StructType\ProdutoRequest[] $produtoRequest
     */
    public function __construct(array $produtoRequest = array())
    {
        $this
            ->setProdutoRequest($produtoRequest);
    }
    /**
     * Get ProdutoRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProdutoRequest[]|null
     */
    public function getProdutoRequest()
    {
        return isset($this->ProdutoRequest) ? $this->ProdutoRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProdutoRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProdutoRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProdutoRequestForArrayConstraintsFromSetProdutoRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfProdutoRequestProdutoRequestItem) {
            // validation for constraint: itemType
            if (!$arrayOfProdutoRequestProdutoRequestItem instanceof \StructType\ProdutoRequest) {
                $invalidValues[] = is_object($arrayOfProdutoRequestProdutoRequestItem) ? get_class($arrayOfProdutoRequestProdutoRequestItem) : sprintf('%s(%s)', gettype($arrayOfProdutoRequestProdutoRequestItem), var_export($arrayOfProdutoRequestProdutoRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProdutoRequest property can only contain items of type \StructType\ProdutoRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProdutoRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProdutoRequest[] $produtoRequest
     * @return \ArrayType\ArrayOfProdutoRequest
     */
    public function setProdutoRequest(array $produtoRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($produtoRequestArrayErrorMessage = self::validateProdutoRequestForArrayConstraintsFromSetProdutoRequest($produtoRequest))) {
            throw new \InvalidArgumentException($produtoRequestArrayErrorMessage, __LINE__);
        }
        if (is_null($produtoRequest) || (is_array($produtoRequest) && empty($produtoRequest))) {
            unset($this->ProdutoRequest);
        } else {
            $this->ProdutoRequest = $produtoRequest;
        }
        return $this;
    }
    /**
     * Add item to ProdutoRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ProdutoRequest $item
     * @return \ArrayType\ArrayOfProdutoRequest
     */
    public function addToProdutoRequest(\StructType\ProdutoRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProdutoRequest) {
            throw new \InvalidArgumentException(sprintf('The ProdutoRequest property can only contain items of type \StructType\ProdutoRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProdutoRequest[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProdutoRequest|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProdutoRequest|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProdutoRequest|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProdutoRequest|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProdutoRequest|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProdutoRequest
     */
    public function getAttributeName()
    {
        return 'ProdutoRequest';
    }
}
