<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContratoResponse ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfContratoResponse
 * @subpackage Arrays
 */
class ArrayOfContratoResponse extends AbstractStructArrayBase
{
    /**
     * The ContratoResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContratoResponse[]
     */
    public $ContratoResponse;
    /**
     * Constructor method for ArrayOfContratoResponse
     * @uses ArrayOfContratoResponse::setContratoResponse()
     * @param \StructType\ContratoResponse[] $contratoResponse
     */
    public function __construct(array $contratoResponse = array())
    {
        $this
            ->setContratoResponse($contratoResponse);
    }
    /**
     * Get ContratoResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContratoResponse[]|null
     */
    public function getContratoResponse()
    {
        return isset($this->ContratoResponse) ? $this->ContratoResponse : null;
    }
    /**
     * This method is responsible for validating the values passed to the setContratoResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContratoResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContratoResponseForArrayConstraintsFromSetContratoResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfContratoResponseContratoResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfContratoResponseContratoResponseItem instanceof \StructType\ContratoResponse) {
                $invalidValues[] = is_object($arrayOfContratoResponseContratoResponseItem) ? get_class($arrayOfContratoResponseContratoResponseItem) : sprintf('%s(%s)', gettype($arrayOfContratoResponseContratoResponseItem), var_export($arrayOfContratoResponseContratoResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContratoResponse property can only contain items of type \StructType\ContratoResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContratoResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ContratoResponse[] $contratoResponse
     * @return \ArrayType\ArrayOfContratoResponse
     */
    public function setContratoResponse(array $contratoResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($contratoResponseArrayErrorMessage = self::validateContratoResponseForArrayConstraintsFromSetContratoResponse($contratoResponse))) {
            throw new \InvalidArgumentException($contratoResponseArrayErrorMessage, __LINE__);
        }
        if (is_null($contratoResponse) || (is_array($contratoResponse) && empty($contratoResponse))) {
            unset($this->ContratoResponse);
        } else {
            $this->ContratoResponse = $contratoResponse;
        }
        return $this;
    }
    /**
     * Add item to ContratoResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ContratoResponse $item
     * @return \ArrayType\ArrayOfContratoResponse
     */
    public function addToContratoResponse(\StructType\ContratoResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContratoResponse) {
            throw new \InvalidArgumentException(sprintf('The ContratoResponse property can only contain items of type \StructType\ContratoResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContratoResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ContratoResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ContratoResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ContratoResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ContratoResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ContratoResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContratoResponse
     */
    public function getAttributeName()
    {
        return 'ContratoResponse';
    }
}
