<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelefoneType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TelefoneType
 * @subpackage Structs
 */
class TelefoneType extends AbstractStructBase
{
    /**
     * The Contato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Contato;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Numero;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacao;
    /**
     * The OrigemDados
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrigemDados;
    /**
     * The TipoTelefone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoTelefone;
    /**
     * The Ativo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Ativo;
    /**
     * The WhatsApp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WhatsApp;
    /**
     * Constructor method for TelefoneType
     * @uses TelefoneType::setContato()
     * @uses TelefoneType::setNumero()
     * @uses TelefoneType::setObservacao()
     * @uses TelefoneType::setOrigemDados()
     * @uses TelefoneType::setTipoTelefone()
     * @uses TelefoneType::setAtivo()
     * @uses TelefoneType::setWhatsApp()
     * @param bool $contato
     * @param string $numero
     * @param string $observacao
     * @param int $origemDados
     * @param string $tipoTelefone
     * @param bool $ativo
     * @param bool $whatsApp
     */
    public function __construct($contato = null, $numero = null, $observacao = null, $origemDados = null, $tipoTelefone = null, $ativo = null, $whatsApp = null)
    {
        $this
            ->setContato($contato)
            ->setNumero($numero)
            ->setObservacao($observacao)
            ->setOrigemDados($origemDados)
            ->setTipoTelefone($tipoTelefone)
            ->setAtivo($ativo)
            ->setWhatsApp($whatsApp);
    }
    /**
     * Get Contato value
     * @return bool|null
     */
    public function getContato()
    {
        return $this->Contato;
    }
    /**
     * Set Contato value
     * @param bool $contato
     * @return \StructType\TelefoneType
     */
    public function setContato($contato = null)
    {
        // validation for constraint: boolean
        if (!is_null($contato) && !is_bool($contato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contato, true), gettype($contato)), __LINE__);
        }
        $this->Contato = $contato;
        return $this;
    }
    /**
     * Get Numero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumero()
    {
        return isset($this->Numero) ? $this->Numero : null;
    }
    /**
     * Set Numero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numero
     * @return \StructType\TelefoneType
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        if (is_null($numero) || (is_array($numero) && empty($numero))) {
            unset($this->Numero);
        } else {
            $this->Numero = $numero;
        }
        return $this;
    }
    /**
     * Get Observacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacao()
    {
        return isset($this->Observacao) ? $this->Observacao : null;
    }
    /**
     * Set Observacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacao
     * @return \StructType\TelefoneType
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        if (is_null($observacao) || (is_array($observacao) && empty($observacao))) {
            unset($this->Observacao);
        } else {
            $this->Observacao = $observacao;
        }
        return $this;
    }
    /**
     * Get OrigemDados value
     * @return int|null
     */
    public function getOrigemDados()
    {
        return $this->OrigemDados;
    }
    /**
     * Set OrigemDados value
     * @param int $origemDados
     * @return \StructType\TelefoneType
     */
    public function setOrigemDados($origemDados = null)
    {
        // validation for constraint: int
        if (!is_null($origemDados) && !(is_int($origemDados) || ctype_digit($origemDados))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($origemDados, true), gettype($origemDados)), __LINE__);
        }
        $this->OrigemDados = $origemDados;
        return $this;
    }
    /**
     * Get TipoTelefone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoTelefone()
    {
        return isset($this->TipoTelefone) ? $this->TipoTelefone : null;
    }
    /**
     * Set TipoTelefone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EnumTipoTelefone::valueIsValid()
     * @uses \EnumType\EnumTipoTelefone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoTelefone
     * @return \StructType\TelefoneType
     */
    public function setTipoTelefone($tipoTelefone = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTipoTelefone::valueIsValid($tipoTelefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTipoTelefone', is_array($tipoTelefone) ? implode(', ', $tipoTelefone) : var_export($tipoTelefone, true), implode(', ', \EnumType\EnumTipoTelefone::getValidValues())), __LINE__);
        }
        if (is_null($tipoTelefone) || (is_array($tipoTelefone) && empty($tipoTelefone))) {
            unset($this->TipoTelefone);
        } else {
            $this->TipoTelefone = $tipoTelefone;
        }
        return $this;
    }
    /**
     * Get Ativo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAtivo()
    {
        return isset($this->Ativo) ? $this->Ativo : null;
    }
    /**
     * Set Ativo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ativo
     * @return \StructType\TelefoneType
     */
    public function setAtivo($ativo = null)
    {
        // validation for constraint: boolean
        if (!is_null($ativo) && !is_bool($ativo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ativo, true), gettype($ativo)), __LINE__);
        }
        if (is_null($ativo) || (is_array($ativo) && empty($ativo))) {
            unset($this->Ativo);
        } else {
            $this->Ativo = $ativo;
        }
        return $this;
    }
    /**
     * Get WhatsApp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWhatsApp()
    {
        return isset($this->WhatsApp) ? $this->WhatsApp : null;
    }
    /**
     * Set WhatsApp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $whatsApp
     * @return \StructType\TelefoneType
     */
    public function setWhatsApp($whatsApp = null)
    {
        // validation for constraint: boolean
        if (!is_null($whatsApp) && !is_bool($whatsApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($whatsApp, true), gettype($whatsApp)), __LINE__);
        }
        if (is_null($whatsApp) || (is_array($whatsApp) && empty($whatsApp))) {
            unset($this->WhatsApp);
        } else {
            $this->WhatsApp = $whatsApp;
        }
        return $this;
    }
}
