<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalvarCliente StructType
 * @subpackage Structs
 */
class SalvarCliente extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The TipoPessoa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoPessoa;
    /**
     * The CpfCnpj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CpfCnpj;
    /**
     * The NomeCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeCliente;
    /**
     * The PessoaFisica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PessoaFisicaRequest
     */
    public $PessoaFisica;
    /**
     * The PessoaJuridica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PessoaJuridicaRequest
     */
    public $PessoaJuridica;
    /**
     * The Telefones
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTelefoneRequest
     */
    public $Telefones;
    /**
     * The Enderecos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEnderecoRequest
     */
    public $Enderecos;
    /**
     * The Emails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEmailRequest
     */
    public $Emails;
    /**
     * The Contratos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfContratoRequest
     */
    public $Contratos;
    /**
     * The DadosAdicionaisCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DadosAdicionaisRequest
     */
    public $DadosAdicionaisCliente;
    /**
     * The Referencias
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfReferenciaRequest
     */
    public $Referencias;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for SalvarCliente
     * @uses SalvarCliente::setChaveCliente()
     * @uses SalvarCliente::setTipoPessoa()
     * @uses SalvarCliente::setCpfCnpj()
     * @uses SalvarCliente::setNomeCliente()
     * @uses SalvarCliente::setPessoaFisica()
     * @uses SalvarCliente::setPessoaJuridica()
     * @uses SalvarCliente::setTelefones()
     * @uses SalvarCliente::setEnderecos()
     * @uses SalvarCliente::setEmails()
     * @uses SalvarCliente::setContratos()
     * @uses SalvarCliente::setDadosAdicionaisCliente()
     * @uses SalvarCliente::setReferencias()
     * @uses SalvarCliente::setToken()
     * @param string $chaveCliente
     * @param string $tipoPessoa
     * @param string $cpfCnpj
     * @param string $nomeCliente
     * @param \StructType\PessoaFisicaRequest $pessoaFisica
     * @param \StructType\PessoaJuridicaRequest $pessoaJuridica
     * @param \ArrayType\ArrayOfTelefoneRequest $telefones
     * @param \ArrayType\ArrayOfEnderecoRequest $enderecos
     * @param \ArrayType\ArrayOfEmailRequest $emails
     * @param \ArrayType\ArrayOfContratoRequest $contratos
     * @param \StructType\DadosAdicionaisRequest $dadosAdicionaisCliente
     * @param \ArrayType\ArrayOfReferenciaRequest $referencias
     * @param string $token
     */
    public function __construct($chaveCliente = null, $tipoPessoa = null, $cpfCnpj = null, $nomeCliente = null, \StructType\PessoaFisicaRequest $pessoaFisica = null, \StructType\PessoaJuridicaRequest $pessoaJuridica = null, \ArrayType\ArrayOfTelefoneRequest $telefones = null, \ArrayType\ArrayOfEnderecoRequest $enderecos = null, \ArrayType\ArrayOfEmailRequest $emails = null, \ArrayType\ArrayOfContratoRequest $contratos = null, \StructType\DadosAdicionaisRequest $dadosAdicionaisCliente = null, \ArrayType\ArrayOfReferenciaRequest $referencias = null, $token = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setTipoPessoa($tipoPessoa)
            ->setCpfCnpj($cpfCnpj)
            ->setNomeCliente($nomeCliente)
            ->setPessoaFisica($pessoaFisica)
            ->setPessoaJuridica($pessoaJuridica)
            ->setTelefones($telefones)
            ->setEnderecos($enderecos)
            ->setEmails($emails)
            ->setContratos($contratos)
            ->setDadosAdicionaisCliente($dadosAdicionaisCliente)
            ->setReferencias($referencias)
            ->setToken($token);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\SalvarCliente
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get TipoPessoa value
     * @return string|null
     */
    public function getTipoPessoa()
    {
        return $this->TipoPessoa;
    }
    /**
     * Set TipoPessoa value
     * @uses \EnumType\EnumTipoPessoa::valueIsValid()
     * @uses \EnumType\EnumTipoPessoa::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoPessoa
     * @return \StructType\SalvarCliente
     */
    public function setTipoPessoa($tipoPessoa = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTipoPessoa::valueIsValid($tipoPessoa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTipoPessoa', is_array($tipoPessoa) ? implode(', ', $tipoPessoa) : var_export($tipoPessoa, true), implode(', ', \EnumType\EnumTipoPessoa::getValidValues())), __LINE__);
        }
        $this->TipoPessoa = $tipoPessoa;
        return $this;
    }
    /**
     * Get CpfCnpj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpfCnpj()
    {
        return isset($this->CpfCnpj) ? $this->CpfCnpj : null;
    }
    /**
     * Set CpfCnpj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpfCnpj
     * @return \StructType\SalvarCliente
     */
    public function setCpfCnpj($cpfCnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cpfCnpj) && !is_string($cpfCnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpfCnpj, true), gettype($cpfCnpj)), __LINE__);
        }
        if (is_null($cpfCnpj) || (is_array($cpfCnpj) && empty($cpfCnpj))) {
            unset($this->CpfCnpj);
        } else {
            $this->CpfCnpj = $cpfCnpj;
        }
        return $this;
    }
    /**
     * Get NomeCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeCliente()
    {
        return isset($this->NomeCliente) ? $this->NomeCliente : null;
    }
    /**
     * Set NomeCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeCliente
     * @return \StructType\SalvarCliente
     */
    public function setNomeCliente($nomeCliente = null)
    {
        // validation for constraint: string
        if (!is_null($nomeCliente) && !is_string($nomeCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeCliente, true), gettype($nomeCliente)), __LINE__);
        }
        if (is_null($nomeCliente) || (is_array($nomeCliente) && empty($nomeCliente))) {
            unset($this->NomeCliente);
        } else {
            $this->NomeCliente = $nomeCliente;
        }
        return $this;
    }
    /**
     * Get PessoaFisica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PessoaFisicaRequest|null
     */
    public function getPessoaFisica()
    {
        return isset($this->PessoaFisica) ? $this->PessoaFisica : null;
    }
    /**
     * Set PessoaFisica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PessoaFisicaRequest $pessoaFisica
     * @return \StructType\SalvarCliente
     */
    public function setPessoaFisica(\StructType\PessoaFisicaRequest $pessoaFisica = null)
    {
        if (is_null($pessoaFisica) || (is_array($pessoaFisica) && empty($pessoaFisica))) {
            unset($this->PessoaFisica);
        } else {
            $this->PessoaFisica = $pessoaFisica;
        }
        return $this;
    }
    /**
     * Get PessoaJuridica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PessoaJuridicaRequest|null
     */
    public function getPessoaJuridica()
    {
        return isset($this->PessoaJuridica) ? $this->PessoaJuridica : null;
    }
    /**
     * Set PessoaJuridica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PessoaJuridicaRequest $pessoaJuridica
     * @return \StructType\SalvarCliente
     */
    public function setPessoaJuridica(\StructType\PessoaJuridicaRequest $pessoaJuridica = null)
    {
        if (is_null($pessoaJuridica) || (is_array($pessoaJuridica) && empty($pessoaJuridica))) {
            unset($this->PessoaJuridica);
        } else {
            $this->PessoaJuridica = $pessoaJuridica;
        }
        return $this;
    }
    /**
     * Get Telefones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTelefoneRequest|null
     */
    public function getTelefones()
    {
        return isset($this->Telefones) ? $this->Telefones : null;
    }
    /**
     * Set Telefones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTelefoneRequest $telefones
     * @return \StructType\SalvarCliente
     */
    public function setTelefones(\ArrayType\ArrayOfTelefoneRequest $telefones = null)
    {
        if (is_null($telefones) || (is_array($telefones) && empty($telefones))) {
            unset($this->Telefones);
        } else {
            $this->Telefones = $telefones;
        }
        return $this;
    }
    /**
     * Get Enderecos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEnderecoRequest|null
     */
    public function getEnderecos()
    {
        return isset($this->Enderecos) ? $this->Enderecos : null;
    }
    /**
     * Set Enderecos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEnderecoRequest $enderecos
     * @return \StructType\SalvarCliente
     */
    public function setEnderecos(\ArrayType\ArrayOfEnderecoRequest $enderecos = null)
    {
        if (is_null($enderecos) || (is_array($enderecos) && empty($enderecos))) {
            unset($this->Enderecos);
        } else {
            $this->Enderecos = $enderecos;
        }
        return $this;
    }
    /**
     * Get Emails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEmailRequest|null
     */
    public function getEmails()
    {
        return isset($this->Emails) ? $this->Emails : null;
    }
    /**
     * Set Emails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEmailRequest $emails
     * @return \StructType\SalvarCliente
     */
    public function setEmails(\ArrayType\ArrayOfEmailRequest $emails = null)
    {
        if (is_null($emails) || (is_array($emails) && empty($emails))) {
            unset($this->Emails);
        } else {
            $this->Emails = $emails;
        }
        return $this;
    }
    /**
     * Get Contratos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfContratoRequest|null
     */
    public function getContratos()
    {
        return isset($this->Contratos) ? $this->Contratos : null;
    }
    /**
     * Set Contratos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfContratoRequest $contratos
     * @return \StructType\SalvarCliente
     */
    public function setContratos(\ArrayType\ArrayOfContratoRequest $contratos = null)
    {
        if (is_null($contratos) || (is_array($contratos) && empty($contratos))) {
            unset($this->Contratos);
        } else {
            $this->Contratos = $contratos;
        }
        return $this;
    }
    /**
     * Get DadosAdicionaisCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DadosAdicionaisRequest|null
     */
    public function getDadosAdicionaisCliente()
    {
        return isset($this->DadosAdicionaisCliente) ? $this->DadosAdicionaisCliente : null;
    }
    /**
     * Set DadosAdicionaisCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DadosAdicionaisRequest $dadosAdicionaisCliente
     * @return \StructType\SalvarCliente
     */
    public function setDadosAdicionaisCliente(\StructType\DadosAdicionaisRequest $dadosAdicionaisCliente = null)
    {
        if (is_null($dadosAdicionaisCliente) || (is_array($dadosAdicionaisCliente) && empty($dadosAdicionaisCliente))) {
            unset($this->DadosAdicionaisCliente);
        } else {
            $this->DadosAdicionaisCliente = $dadosAdicionaisCliente;
        }
        return $this;
    }
    /**
     * Get Referencias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfReferenciaRequest|null
     */
    public function getReferencias()
    {
        return isset($this->Referencias) ? $this->Referencias : null;
    }
    /**
     * Set Referencias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfReferenciaRequest $referencias
     * @return \StructType\SalvarCliente
     */
    public function setReferencias(\ArrayType\ArrayOfReferenciaRequest $referencias = null)
    {
        if (is_null($referencias) || (is_array($referencias) && empty($referencias))) {
            unset($this->Referencias);
        } else {
            $this->Referencias = $referencias;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\SalvarCliente
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
