<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoverSPC StructType
 * @subpackage Structs
 */
class RemoverSPC extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The Contrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Contrato;
    /**
     * The DataExclusao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataExclusao;
    /**
     * The TipoSPC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoSPC;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for RemoverSPC
     * @uses RemoverSPC::setChaveCliente()
     * @uses RemoverSPC::setContrato()
     * @uses RemoverSPC::setDataExclusao()
     * @uses RemoverSPC::setTipoSPC()
     * @uses RemoverSPC::setToken()
     * @param string $chaveCliente
     * @param string $contrato
     * @param string $dataExclusao
     * @param string $tipoSPC
     * @param string $token
     */
    public function __construct($chaveCliente = null, $contrato = null, $dataExclusao = null, $tipoSPC = null, $token = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setContrato($contrato)
            ->setDataExclusao($dataExclusao)
            ->setTipoSPC($tipoSPC)
            ->setToken($token);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\RemoverSPC
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get Contrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContrato()
    {
        return isset($this->Contrato) ? $this->Contrato : null;
    }
    /**
     * Set Contrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contrato
     * @return \StructType\RemoverSPC
     */
    public function setContrato($contrato = null)
    {
        // validation for constraint: string
        if (!is_null($contrato) && !is_string($contrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrato, true), gettype($contrato)), __LINE__);
        }
        if (is_null($contrato) || (is_array($contrato) && empty($contrato))) {
            unset($this->Contrato);
        } else {
            $this->Contrato = $contrato;
        }
        return $this;
    }
    /**
     * Get DataExclusao value
     * @return string|null
     */
    public function getDataExclusao()
    {
        return $this->DataExclusao;
    }
    /**
     * Set DataExclusao value
     * @param string $dataExclusao
     * @return \StructType\RemoverSPC
     */
    public function setDataExclusao($dataExclusao = null)
    {
        // validation for constraint: string
        if (!is_null($dataExclusao) && !is_string($dataExclusao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataExclusao, true), gettype($dataExclusao)), __LINE__);
        }
        $this->DataExclusao = $dataExclusao;
        return $this;
    }
    /**
     * Get TipoSPC value
     * @return string|null
     */
    public function getTipoSPC()
    {
        return $this->TipoSPC;
    }
    /**
     * Set TipoSPC value
     * @uses \EnumType\EnumTipoSPC::valueIsValid()
     * @uses \EnumType\EnumTipoSPC::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoSPC
     * @return \StructType\RemoverSPC
     */
    public function setTipoSPC($tipoSPC = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTipoSPC::valueIsValid($tipoSPC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTipoSPC', is_array($tipoSPC) ? implode(', ', $tipoSPC) : var_export($tipoSPC, true), implode(', ', \EnumType\EnumTipoSPC::getValidValues())), __LINE__);
        }
        $this->TipoSPC = $tipoSPC;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\RemoverSPC
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
