<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuebrarAcordo StructType
 * @subpackage Structs
 */
class QuebrarAcordo extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The NumeroAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroAcordo;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacao;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for QuebrarAcordo
     * @uses QuebrarAcordo::setChaveCliente()
     * @uses QuebrarAcordo::setNumeroAcordo()
     * @uses QuebrarAcordo::setObservacao()
     * @uses QuebrarAcordo::setToken()
     * @param string $chaveCliente
     * @param int $numeroAcordo
     * @param string $observacao
     * @param string $token
     */
    public function __construct($chaveCliente = null, $numeroAcordo = null, $observacao = null, $token = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setNumeroAcordo($numeroAcordo)
            ->setObservacao($observacao)
            ->setToken($token);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\QuebrarAcordo
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get NumeroAcordo value
     * @return int|null
     */
    public function getNumeroAcordo()
    {
        return $this->NumeroAcordo;
    }
    /**
     * Set NumeroAcordo value
     * @param int $numeroAcordo
     * @return \StructType\QuebrarAcordo
     */
    public function setNumeroAcordo($numeroAcordo = null)
    {
        // validation for constraint: int
        if (!is_null($numeroAcordo) && !(is_int($numeroAcordo) || ctype_digit($numeroAcordo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroAcordo, true), gettype($numeroAcordo)), __LINE__);
        }
        $this->NumeroAcordo = $numeroAcordo;
        return $this;
    }
    /**
     * Get Observacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacao()
    {
        return isset($this->Observacao) ? $this->Observacao : null;
    }
    /**
     * Set Observacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacao
     * @return \StructType\QuebrarAcordo
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        if (is_null($observacao) || (is_array($observacao) && empty($observacao))) {
            unset($this->Observacao);
        } else {
            $this->Observacao = $observacao;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\QuebrarAcordo
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
