<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParcelaCalculoRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ParcelaCalculoRequest
 * @subpackage Structs
 */
class ParcelaCalculoRequest extends AbstractStructBase
{
    /**
     * The DataCalculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataCalculo;
    /**
     * The DataCalculoOrdem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DataCalculoOrdem;
    /**
     * The DataCalculoOrdemSequencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DataCalculoOrdemSequencia;
    /**
     * The DataCalculoQtde
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DataCalculoQtde;
    /**
     * The DiaVencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DiaVencimento;
    /**
     * The EmailCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailCliente;
    /**
     * The Entrada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Entrada;
    /**
     * The FormaPagamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FormaPagamento;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacao;
    /**
     * The ParcelaParcelamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelaParcelamento;
    /**
     * The ParcelasOriginais
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaCalculoType
     */
    public $ParcelasOriginais;
    /**
     * Constructor method for ParcelaCalculoRequest
     * @uses ParcelaCalculoRequest::setDataCalculo()
     * @uses ParcelaCalculoRequest::setDataCalculoOrdem()
     * @uses ParcelaCalculoRequest::setDataCalculoOrdemSequencia()
     * @uses ParcelaCalculoRequest::setDataCalculoQtde()
     * @uses ParcelaCalculoRequest::setDiaVencimento()
     * @uses ParcelaCalculoRequest::setEmailCliente()
     * @uses ParcelaCalculoRequest::setEntrada()
     * @uses ParcelaCalculoRequest::setFormaPagamento()
     * @uses ParcelaCalculoRequest::setObservacao()
     * @uses ParcelaCalculoRequest::setParcelaParcelamento()
     * @uses ParcelaCalculoRequest::setParcelasOriginais()
     * @param string $dataCalculo
     * @param int $dataCalculoOrdem
     * @param int $dataCalculoOrdemSequencia
     * @param int $dataCalculoQtde
     * @param int $diaVencimento
     * @param string $emailCliente
     * @param bool $entrada
     * @param int $formaPagamento
     * @param string $observacao
     * @param int $parcelaParcelamento
     * @param \ArrayType\ArrayOfParcelaCalculoType $parcelasOriginais
     */
    public function __construct($dataCalculo = null, $dataCalculoOrdem = null, $dataCalculoOrdemSequencia = null, $dataCalculoQtde = null, $diaVencimento = null, $emailCliente = null, $entrada = null, $formaPagamento = null, $observacao = null, $parcelaParcelamento = null, \ArrayType\ArrayOfParcelaCalculoType $parcelasOriginais = null)
    {
        $this
            ->setDataCalculo($dataCalculo)
            ->setDataCalculoOrdem($dataCalculoOrdem)
            ->setDataCalculoOrdemSequencia($dataCalculoOrdemSequencia)
            ->setDataCalculoQtde($dataCalculoQtde)
            ->setDiaVencimento($diaVencimento)
            ->setEmailCliente($emailCliente)
            ->setEntrada($entrada)
            ->setFormaPagamento($formaPagamento)
            ->setObservacao($observacao)
            ->setParcelaParcelamento($parcelaParcelamento)
            ->setParcelasOriginais($parcelasOriginais);
    }
    /**
     * Get DataCalculo value
     * @return string|null
     */
    public function getDataCalculo()
    {
        return $this->DataCalculo;
    }
    /**
     * Set DataCalculo value
     * @param string $dataCalculo
     * @return \StructType\ParcelaCalculoRequest
     */
    public function setDataCalculo($dataCalculo = null)
    {
        // validation for constraint: string
        if (!is_null($dataCalculo) && !is_string($dataCalculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataCalculo, true), gettype($dataCalculo)), __LINE__);
        }
        $this->DataCalculo = $dataCalculo;
        return $this;
    }
    /**
     * Get DataCalculoOrdem value
     * @return int|null
     */
    public function getDataCalculoOrdem()
    {
        return $this->DataCalculoOrdem;
    }
    /**
     * Set DataCalculoOrdem value
     * @param int $dataCalculoOrdem
     * @return \StructType\ParcelaCalculoRequest
     */
    public function setDataCalculoOrdem($dataCalculoOrdem = null)
    {
        // validation for constraint: int
        if (!is_null($dataCalculoOrdem) && !(is_int($dataCalculoOrdem) || ctype_digit($dataCalculoOrdem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dataCalculoOrdem, true), gettype($dataCalculoOrdem)), __LINE__);
        }
        $this->DataCalculoOrdem = $dataCalculoOrdem;
        return $this;
    }
    /**
     * Get DataCalculoOrdemSequencia value
     * @return int|null
     */
    public function getDataCalculoOrdemSequencia()
    {
        return $this->DataCalculoOrdemSequencia;
    }
    /**
     * Set DataCalculoOrdemSequencia value
     * @param int $dataCalculoOrdemSequencia
     * @return \StructType\ParcelaCalculoRequest
     */
    public function setDataCalculoOrdemSequencia($dataCalculoOrdemSequencia = null)
    {
        // validation for constraint: int
        if (!is_null($dataCalculoOrdemSequencia) && !(is_int($dataCalculoOrdemSequencia) || ctype_digit($dataCalculoOrdemSequencia))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dataCalculoOrdemSequencia, true), gettype($dataCalculoOrdemSequencia)), __LINE__);
        }
        $this->DataCalculoOrdemSequencia = $dataCalculoOrdemSequencia;
        return $this;
    }
    /**
     * Get DataCalculoQtde value
     * @return int|null
     */
    public function getDataCalculoQtde()
    {
        return $this->DataCalculoQtde;
    }
    /**
     * Set DataCalculoQtde value
     * @param int $dataCalculoQtde
     * @return \StructType\ParcelaCalculoRequest
     */
    public function setDataCalculoQtde($dataCalculoQtde = null)
    {
        // validation for constraint: int
        if (!is_null($dataCalculoQtde) && !(is_int($dataCalculoQtde) || ctype_digit($dataCalculoQtde))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dataCalculoQtde, true), gettype($dataCalculoQtde)), __LINE__);
        }
        $this->DataCalculoQtde = $dataCalculoQtde;
        return $this;
    }
    /**
     * Get DiaVencimento value
     * @return int|null
     */
    public function getDiaVencimento()
    {
        return $this->DiaVencimento;
    }
    /**
     * Set DiaVencimento value
     * @param int $diaVencimento
     * @return \StructType\ParcelaCalculoRequest
     */
    public function setDiaVencimento($diaVencimento = null)
    {
        // validation for constraint: int
        if (!is_null($diaVencimento) && !(is_int($diaVencimento) || ctype_digit($diaVencimento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($diaVencimento, true), gettype($diaVencimento)), __LINE__);
        }
        $this->DiaVencimento = $diaVencimento;
        return $this;
    }
    /**
     * Get EmailCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailCliente()
    {
        return isset($this->EmailCliente) ? $this->EmailCliente : null;
    }
    /**
     * Set EmailCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailCliente
     * @return \StructType\ParcelaCalculoRequest
     */
    public function setEmailCliente($emailCliente = null)
    {
        // validation for constraint: string
        if (!is_null($emailCliente) && !is_string($emailCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailCliente, true), gettype($emailCliente)), __LINE__);
        }
        if (is_null($emailCliente) || (is_array($emailCliente) && empty($emailCliente))) {
            unset($this->EmailCliente);
        } else {
            $this->EmailCliente = $emailCliente;
        }
        return $this;
    }
    /**
     * Get Entrada value
     * @return bool|null
     */
    public function getEntrada()
    {
        return $this->Entrada;
    }
    /**
     * Set Entrada value
     * @param bool $entrada
     * @return \StructType\ParcelaCalculoRequest
     */
    public function setEntrada($entrada = null)
    {
        // validation for constraint: boolean
        if (!is_null($entrada) && !is_bool($entrada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($entrada, true), gettype($entrada)), __LINE__);
        }
        $this->Entrada = $entrada;
        return $this;
    }
    /**
     * Get FormaPagamento value
     * @return int|null
     */
    public function getFormaPagamento()
    {
        return $this->FormaPagamento;
    }
    /**
     * Set FormaPagamento value
     * @param int $formaPagamento
     * @return \StructType\ParcelaCalculoRequest
     */
    public function setFormaPagamento($formaPagamento = null)
    {
        // validation for constraint: int
        if (!is_null($formaPagamento) && !(is_int($formaPagamento) || ctype_digit($formaPagamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($formaPagamento, true), gettype($formaPagamento)), __LINE__);
        }
        $this->FormaPagamento = $formaPagamento;
        return $this;
    }
    /**
     * Get Observacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacao()
    {
        return isset($this->Observacao) ? $this->Observacao : null;
    }
    /**
     * Set Observacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacao
     * @return \StructType\ParcelaCalculoRequest
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        if (is_null($observacao) || (is_array($observacao) && empty($observacao))) {
            unset($this->Observacao);
        } else {
            $this->Observacao = $observacao;
        }
        return $this;
    }
    /**
     * Get ParcelaParcelamento value
     * @return int|null
     */
    public function getParcelaParcelamento()
    {
        return $this->ParcelaParcelamento;
    }
    /**
     * Set ParcelaParcelamento value
     * @param int $parcelaParcelamento
     * @return \StructType\ParcelaCalculoRequest
     */
    public function setParcelaParcelamento($parcelaParcelamento = null)
    {
        // validation for constraint: int
        if (!is_null($parcelaParcelamento) && !(is_int($parcelaParcelamento) || ctype_digit($parcelaParcelamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelaParcelamento, true), gettype($parcelaParcelamento)), __LINE__);
        }
        $this->ParcelaParcelamento = $parcelaParcelamento;
        return $this;
    }
    /**
     * Get ParcelasOriginais value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaCalculoType|null
     */
    public function getParcelasOriginais()
    {
        return isset($this->ParcelasOriginais) ? $this->ParcelasOriginais : null;
    }
    /**
     * Set ParcelasOriginais value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaCalculoType $parcelasOriginais
     * @return \StructType\ParcelaCalculoRequest
     */
    public function setParcelasOriginais(\ArrayType\ArrayOfParcelaCalculoType $parcelasOriginais = null)
    {
        if (is_null($parcelasOriginais) || (is_array($parcelasOriginais) && empty($parcelasOriginais))) {
            unset($this->ParcelasOriginais);
        } else {
            $this->ParcelasOriginais = $parcelasOriginais;
        }
        return $this;
    }
}
