<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParcelaAcordoType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ParcelaAcordoType
 * @subpackage Structs
 */
class ParcelaAcordoType extends AbstractStructBase
{
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Numero;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Valor;
    /**
     * The Vencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vencimento;
    /**
     * Constructor method for ParcelaAcordoType
     * @uses ParcelaAcordoType::setNumero()
     * @uses ParcelaAcordoType::setValor()
     * @uses ParcelaAcordoType::setVencimento()
     * @param int $numero
     * @param float $valor
     * @param string $vencimento
     */
    public function __construct($numero = null, $valor = null, $vencimento = null)
    {
        $this
            ->setNumero($numero)
            ->setValor($valor)
            ->setVencimento($vencimento);
    }
    /**
     * Get Numero value
     * @return int|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param int $numero
     * @return \StructType\ParcelaAcordoType
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: int
        if (!is_null($numero) && !(is_int($numero) || ctype_digit($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\ParcelaAcordoType
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get Vencimento value
     * @return string|null
     */
    public function getVencimento()
    {
        return $this->Vencimento;
    }
    /**
     * Set Vencimento value
     * @param string $vencimento
     * @return \StructType\ParcelaAcordoType
     */
    public function setVencimento($vencimento = null)
    {
        // validation for constraint: string
        if (!is_null($vencimento) && !is_string($vencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimento, true), gettype($vencimento)), __LINE__);
        }
        $this->Vencimento = $vencimento;
        return $this;
    }
}
