<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagamentoDiretoType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PagamentoDiretoType
 * @subpackage Structs
 */
class PagamentoDiretoType extends AbstractStructBase
{
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Data;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Numero;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacao;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Valor;
    /**
     * The ValorPago
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorPago;
    /**
     * The ValorPagoPrincipal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorPagoPrincipal;
    /**
     * The Vencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vencimento;
    /**
     * Constructor method for PagamentoDiretoType
     * @uses PagamentoDiretoType::setData()
     * @uses PagamentoDiretoType::setNumero()
     * @uses PagamentoDiretoType::setObservacao()
     * @uses PagamentoDiretoType::setValor()
     * @uses PagamentoDiretoType::setValorPago()
     * @uses PagamentoDiretoType::setValorPagoPrincipal()
     * @uses PagamentoDiretoType::setVencimento()
     * @param string $data
     * @param string $numero
     * @param string $observacao
     * @param float $valor
     * @param float $valorPago
     * @param float $valorPagoPrincipal
     * @param string $vencimento
     */
    public function __construct($data = null, $numero = null, $observacao = null, $valor = null, $valorPago = null, $valorPagoPrincipal = null, $vencimento = null)
    {
        $this
            ->setData($data)
            ->setNumero($numero)
            ->setObservacao($observacao)
            ->setValor($valor)
            ->setValorPago($valorPago)
            ->setValorPagoPrincipal($valorPagoPrincipal)
            ->setVencimento($vencimento);
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \StructType\PagamentoDiretoType
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Numero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumero()
    {
        return isset($this->Numero) ? $this->Numero : null;
    }
    /**
     * Set Numero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numero
     * @return \StructType\PagamentoDiretoType
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        if (is_null($numero) || (is_array($numero) && empty($numero))) {
            unset($this->Numero);
        } else {
            $this->Numero = $numero;
        }
        return $this;
    }
    /**
     * Get Observacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacao()
    {
        return isset($this->Observacao) ? $this->Observacao : null;
    }
    /**
     * Set Observacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacao
     * @return \StructType\PagamentoDiretoType
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        if (is_null($observacao) || (is_array($observacao) && empty($observacao))) {
            unset($this->Observacao);
        } else {
            $this->Observacao = $observacao;
        }
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\PagamentoDiretoType
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get ValorPago value
     * @return float|null
     */
    public function getValorPago()
    {
        return $this->ValorPago;
    }
    /**
     * Set ValorPago value
     * @param float $valorPago
     * @return \StructType\PagamentoDiretoType
     */
    public function setValorPago($valorPago = null)
    {
        // validation for constraint: float
        if (!is_null($valorPago) && !(is_float($valorPago) || is_numeric($valorPago))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorPago, true), gettype($valorPago)), __LINE__);
        }
        $this->ValorPago = $valorPago;
        return $this;
    }
    /**
     * Get ValorPagoPrincipal value
     * @return float|null
     */
    public function getValorPagoPrincipal()
    {
        return $this->ValorPagoPrincipal;
    }
    /**
     * Set ValorPagoPrincipal value
     * @param float $valorPagoPrincipal
     * @return \StructType\PagamentoDiretoType
     */
    public function setValorPagoPrincipal($valorPagoPrincipal = null)
    {
        // validation for constraint: float
        if (!is_null($valorPagoPrincipal) && !(is_float($valorPagoPrincipal) || is_numeric($valorPagoPrincipal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorPagoPrincipal, true), gettype($valorPagoPrincipal)), __LINE__);
        }
        $this->ValorPagoPrincipal = $valorPagoPrincipal;
        return $this;
    }
    /**
     * Get Vencimento value
     * @return string|null
     */
    public function getVencimento()
    {
        return $this->Vencimento;
    }
    /**
     * Set Vencimento value
     * @param string $vencimento
     * @return \StructType\PagamentoDiretoType
     */
    public function setVencimento($vencimento = null)
    {
        // validation for constraint: string
        if (!is_null($vencimento) && !is_string($vencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimento, true), gettype($vencimento)), __LINE__);
        }
        $this->Vencimento = $vencimento;
        return $this;
    }
}
