<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginPortal StructType
 * @subpackage Structs
 */
class LoginPortal extends AbstractStructBase
{
    /**
     * The CPFCNPJ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPFCNPJ;
    /**
     * The dataNasc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dataNasc;
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codigo;
    /**
     * The IdCredor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCredor;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * The IdOrigem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdOrigem;
    /**
     * Constructor method for LoginPortal
     * @uses LoginPortal::setCPFCNPJ()
     * @uses LoginPortal::setDataNasc()
     * @uses LoginPortal::setCodigo()
     * @uses LoginPortal::setIdCredor()
     * @uses LoginPortal::setToken()
     * @uses LoginPortal::setIdOrigem()
     * @param string $cPFCNPJ
     * @param string $dataNasc
     * @param string $codigo
     * @param int $idCredor
     * @param string $token
     * @param string $idOrigem
     */
    public function __construct($cPFCNPJ = null, $dataNasc = null, $codigo = null, $idCredor = null, $token = null, $idOrigem = null)
    {
        $this
            ->setCPFCNPJ($cPFCNPJ)
            ->setDataNasc($dataNasc)
            ->setCodigo($codigo)
            ->setIdCredor($idCredor)
            ->setToken($token)
            ->setIdOrigem($idOrigem);
    }
    /**
     * Get CPFCNPJ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPFCNPJ()
    {
        return isset($this->CPFCNPJ) ? $this->CPFCNPJ : null;
    }
    /**
     * Set CPFCNPJ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPFCNPJ
     * @return \StructType\LoginPortal
     */
    public function setCPFCNPJ($cPFCNPJ = null)
    {
        // validation for constraint: string
        if (!is_null($cPFCNPJ) && !is_string($cPFCNPJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPFCNPJ, true), gettype($cPFCNPJ)), __LINE__);
        }
        if (is_null($cPFCNPJ) || (is_array($cPFCNPJ) && empty($cPFCNPJ))) {
            unset($this->CPFCNPJ);
        } else {
            $this->CPFCNPJ = $cPFCNPJ;
        }
        return $this;
    }
    /**
     * Get dataNasc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataNasc()
    {
        return isset($this->dataNasc) ? $this->dataNasc : null;
    }
    /**
     * Set dataNasc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataNasc
     * @return \StructType\LoginPortal
     */
    public function setDataNasc($dataNasc = null)
    {
        // validation for constraint: string
        if (!is_null($dataNasc) && !is_string($dataNasc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataNasc, true), gettype($dataNasc)), __LINE__);
        }
        if (is_null($dataNasc) || (is_array($dataNasc) && empty($dataNasc))) {
            unset($this->dataNasc);
        } else {
            $this->dataNasc = $dataNasc;
        }
        return $this;
    }
    /**
     * Get codigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigo()
    {
        return isset($this->codigo) ? $this->codigo : null;
    }
    /**
     * Set codigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigo
     * @return \StructType\LoginPortal
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        if (is_null($codigo) || (is_array($codigo) && empty($codigo))) {
            unset($this->codigo);
        } else {
            $this->codigo = $codigo;
        }
        return $this;
    }
    /**
     * Get IdCredor value
     * @return int|null
     */
    public function getIdCredor()
    {
        return $this->IdCredor;
    }
    /**
     * Set IdCredor value
     * @param int $idCredor
     * @return \StructType\LoginPortal
     */
    public function setIdCredor($idCredor = null)
    {
        // validation for constraint: int
        if (!is_null($idCredor) && !(is_int($idCredor) || ctype_digit($idCredor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCredor, true), gettype($idCredor)), __LINE__);
        }
        $this->IdCredor = $idCredor;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\LoginPortal
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
    /**
     * Get IdOrigem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdOrigem()
    {
        return isset($this->IdOrigem) ? $this->IdOrigem : null;
    }
    /**
     * Set IdOrigem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idOrigem
     * @return \StructType\LoginPortal
     */
    public function setIdOrigem($idOrigem = null)
    {
        // validation for constraint: string
        if (!is_null($idOrigem) && !is_string($idOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idOrigem, true), gettype($idOrigem)), __LINE__);
        }
        if (is_null($idOrigem) || (is_array($idOrigem) && empty($idOrigem))) {
            unset($this->IdOrigem);
        } else {
            $this->IdOrigem = $idOrigem;
        }
        return $this;
    }
}
