<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetToken StructType
 * @subpackage Structs
 */
class GetToken extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $usuario;
    /**
     * The senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $senha;
    /**
     * Constructor method for GetToken
     * @uses GetToken::setUsuario()
     * @uses GetToken::setSenha()
     * @param string $usuario
     * @param string $senha
     */
    public function __construct($usuario = null, $senha = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha);
    }
    /**
     * Get usuario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsuario()
    {
        return isset($this->usuario) ? $this->usuario : null;
    }
    /**
     * Set usuario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usuario
     * @return \StructType\GetToken
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        if (is_null($usuario) || (is_array($usuario) && empty($usuario))) {
            unset($this->usuario);
        } else {
            $this->usuario = $usuario;
        }
        return $this;
    }
    /**
     * Get senha value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenha()
    {
        return isset($this->senha) ? $this->senha : null;
    }
    /**
     * Set senha value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senha
     * @return \StructType\GetToken
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        if (is_null($senha) || (is_array($senha) && empty($senha))) {
            unset($this->senha);
        } else {
            $this->senha = $senha;
        }
        return $this;
    }
}
