<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FilialKrotonType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FilialKrotonType
 * @subpackage Structs
 */
class FilialKrotonType extends AbstractStructBase
{
    /**
     * The CNPJ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CNPJ;
    /**
     * The Codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Codigo;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The MarcaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MarcaId;
    /**
     * The MarcaLogo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarcaLogo;
    /**
     * The MarcaNome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarcaNome;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * The NomeCurso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeCurso;
    /**
     * The RazaoSocial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RazaoSocial;
    /**
     * Constructor method for FilialKrotonType
     * @uses FilialKrotonType::setCNPJ()
     * @uses FilialKrotonType::setCodigo()
     * @uses FilialKrotonType::setId()
     * @uses FilialKrotonType::setMarcaId()
     * @uses FilialKrotonType::setMarcaLogo()
     * @uses FilialKrotonType::setMarcaNome()
     * @uses FilialKrotonType::setNome()
     * @uses FilialKrotonType::setNomeCurso()
     * @uses FilialKrotonType::setRazaoSocial()
     * @param string $cNPJ
     * @param string $codigo
     * @param int $id
     * @param int $marcaId
     * @param string $marcaLogo
     * @param string $marcaNome
     * @param string $nome
     * @param string $nomeCurso
     * @param string $razaoSocial
     */
    public function __construct($cNPJ = null, $codigo = null, $id = null, $marcaId = null, $marcaLogo = null, $marcaNome = null, $nome = null, $nomeCurso = null, $razaoSocial = null)
    {
        $this
            ->setCNPJ($cNPJ)
            ->setCodigo($codigo)
            ->setId($id)
            ->setMarcaId($marcaId)
            ->setMarcaLogo($marcaLogo)
            ->setMarcaNome($marcaNome)
            ->setNome($nome)
            ->setNomeCurso($nomeCurso)
            ->setRazaoSocial($razaoSocial);
    }
    /**
     * Get CNPJ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCNPJ()
    {
        return isset($this->CNPJ) ? $this->CNPJ : null;
    }
    /**
     * Set CNPJ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cNPJ
     * @return \StructType\FilialKrotonType
     */
    public function setCNPJ($cNPJ = null)
    {
        // validation for constraint: string
        if (!is_null($cNPJ) && !is_string($cNPJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cNPJ, true), gettype($cNPJ)), __LINE__);
        }
        if (is_null($cNPJ) || (is_array($cNPJ) && empty($cNPJ))) {
            unset($this->CNPJ);
        } else {
            $this->CNPJ = $cNPJ;
        }
        return $this;
    }
    /**
     * Get Codigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigo()
    {
        return isset($this->Codigo) ? $this->Codigo : null;
    }
    /**
     * Set Codigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigo
     * @return \StructType\FilialKrotonType
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        if (is_null($codigo) || (is_array($codigo) && empty($codigo))) {
            unset($this->Codigo);
        } else {
            $this->Codigo = $codigo;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\FilialKrotonType
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get MarcaId value
     * @return int|null
     */
    public function getMarcaId()
    {
        return $this->MarcaId;
    }
    /**
     * Set MarcaId value
     * @param int $marcaId
     * @return \StructType\FilialKrotonType
     */
    public function setMarcaId($marcaId = null)
    {
        // validation for constraint: int
        if (!is_null($marcaId) && !(is_int($marcaId) || ctype_digit($marcaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($marcaId, true), gettype($marcaId)), __LINE__);
        }
        $this->MarcaId = $marcaId;
        return $this;
    }
    /**
     * Get MarcaLogo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarcaLogo()
    {
        return isset($this->MarcaLogo) ? $this->MarcaLogo : null;
    }
    /**
     * Set MarcaLogo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marcaLogo
     * @return \StructType\FilialKrotonType
     */
    public function setMarcaLogo($marcaLogo = null)
    {
        // validation for constraint: string
        if (!is_null($marcaLogo) && !is_string($marcaLogo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marcaLogo, true), gettype($marcaLogo)), __LINE__);
        }
        if (is_null($marcaLogo) || (is_array($marcaLogo) && empty($marcaLogo))) {
            unset($this->MarcaLogo);
        } else {
            $this->MarcaLogo = $marcaLogo;
        }
        return $this;
    }
    /**
     * Get MarcaNome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarcaNome()
    {
        return isset($this->MarcaNome) ? $this->MarcaNome : null;
    }
    /**
     * Set MarcaNome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marcaNome
     * @return \StructType\FilialKrotonType
     */
    public function setMarcaNome($marcaNome = null)
    {
        // validation for constraint: string
        if (!is_null($marcaNome) && !is_string($marcaNome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marcaNome, true), gettype($marcaNome)), __LINE__);
        }
        if (is_null($marcaNome) || (is_array($marcaNome) && empty($marcaNome))) {
            unset($this->MarcaNome);
        } else {
            $this->MarcaNome = $marcaNome;
        }
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \StructType\FilialKrotonType
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
    /**
     * Get NomeCurso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeCurso()
    {
        return isset($this->NomeCurso) ? $this->NomeCurso : null;
    }
    /**
     * Set NomeCurso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeCurso
     * @return \StructType\FilialKrotonType
     */
    public function setNomeCurso($nomeCurso = null)
    {
        // validation for constraint: string
        if (!is_null($nomeCurso) && !is_string($nomeCurso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeCurso, true), gettype($nomeCurso)), __LINE__);
        }
        if (is_null($nomeCurso) || (is_array($nomeCurso) && empty($nomeCurso))) {
            unset($this->NomeCurso);
        } else {
            $this->NomeCurso = $nomeCurso;
        }
        return $this;
    }
    /**
     * Get RazaoSocial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRazaoSocial()
    {
        return isset($this->RazaoSocial) ? $this->RazaoSocial : null;
    }
    /**
     * Set RazaoSocial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $razaoSocial
     * @return \StructType\FilialKrotonType
     */
    public function setRazaoSocial($razaoSocial = null)
    {
        // validation for constraint: string
        if (!is_null($razaoSocial) && !is_string($razaoSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($razaoSocial, true), gettype($razaoSocial)), __LINE__);
        }
        if (is_null($razaoSocial) || (is_array($razaoSocial) && empty($razaoSocial))) {
            unset($this->RazaoSocial);
        } else {
            $this->RazaoSocial = $razaoSocial;
        }
        return $this;
    }
}
