<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventoClienteResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventoClienteResponse
 * @subpackage Structs
 */
class EventoClienteResponse extends EventoType
{
    /**
     * The Contratos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEventoContratoResponse
     */
    public $Contratos;
    /**
     * The IdEvento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdEvento;
    /**
     * The chaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $chaveCliente;
    /**
     * Constructor method for EventoClienteResponse
     * @uses EventoClienteResponse::setContratos()
     * @uses EventoClienteResponse::setIdEvento()
     * @uses EventoClienteResponse::setChaveCliente()
     * @param \ArrayType\ArrayOfEventoContratoResponse $contratos
     * @param int $idEvento
     * @param string $chaveCliente
     */
    public function __construct(\ArrayType\ArrayOfEventoContratoResponse $contratos = null, $idEvento = null, $chaveCliente = null)
    {
        $this
            ->setContratos($contratos)
            ->setIdEvento($idEvento)
            ->setChaveCliente($chaveCliente);
    }
    /**
     * Get Contratos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEventoContratoResponse|null
     */
    public function getContratos()
    {
        return isset($this->Contratos) ? $this->Contratos : null;
    }
    /**
     * Set Contratos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEventoContratoResponse $contratos
     * @return \StructType\EventoClienteResponse
     */
    public function setContratos(\ArrayType\ArrayOfEventoContratoResponse $contratos = null)
    {
        if (is_null($contratos) || (is_array($contratos) && empty($contratos))) {
            unset($this->Contratos);
        } else {
            $this->Contratos = $contratos;
        }
        return $this;
    }
    /**
     * Get IdEvento value
     * @return int|null
     */
    public function getIdEvento()
    {
        return $this->IdEvento;
    }
    /**
     * Set IdEvento value
     * @param int $idEvento
     * @return \StructType\EventoClienteResponse
     */
    public function setIdEvento($idEvento = null)
    {
        // validation for constraint: int
        if (!is_null($idEvento) && !(is_int($idEvento) || ctype_digit($idEvento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idEvento, true), gettype($idEvento)), __LINE__);
        }
        $this->IdEvento = $idEvento;
        return $this;
    }
    /**
     * Get chaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->chaveCliente) ? $this->chaveCliente : null;
    }
    /**
     * Set chaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\EventoClienteResponse
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->chaveCliente);
        } else {
            $this->chaveCliente = $chaveCliente;
        }
        return $this;
    }
}
