<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnviaBoletoUra StructType
 * @subpackage Structs
 */
class EnviaBoletoUra extends AbstractStructBase
{
    /**
     * The IdAcordoCriptografado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdAcordoCriptografado;
    /**
     * The IdBoleto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdBoleto;
    /**
     * The numParcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numParcela;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The telefone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $telefone;
    /**
     * The IdPessoa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdPessoa;
    /**
     * The IdCredor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCredor;
    /**
     * The BoletoOriginal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BoletoOriginal;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for EnviaBoletoUra
     * @uses EnviaBoletoUra::setIdAcordoCriptografado()
     * @uses EnviaBoletoUra::setIdBoleto()
     * @uses EnviaBoletoUra::setNumParcela()
     * @uses EnviaBoletoUra::setEmail()
     * @uses EnviaBoletoUra::setTelefone()
     * @uses EnviaBoletoUra::setIdPessoa()
     * @uses EnviaBoletoUra::setIdCredor()
     * @uses EnviaBoletoUra::setBoletoOriginal()
     * @uses EnviaBoletoUra::setToken()
     * @param string $idAcordoCriptografado
     * @param int $idBoleto
     * @param string $numParcela
     * @param string $email
     * @param string $telefone
     * @param int $idPessoa
     * @param int $idCredor
     * @param bool $boletoOriginal
     * @param string $token
     */
    public function __construct($idAcordoCriptografado = null, $idBoleto = null, $numParcela = null, $email = null, $telefone = null, $idPessoa = null, $idCredor = null, $boletoOriginal = null, $token = null)
    {
        $this
            ->setIdAcordoCriptografado($idAcordoCriptografado)
            ->setIdBoleto($idBoleto)
            ->setNumParcela($numParcela)
            ->setEmail($email)
            ->setTelefone($telefone)
            ->setIdPessoa($idPessoa)
            ->setIdCredor($idCredor)
            ->setBoletoOriginal($boletoOriginal)
            ->setToken($token);
    }
    /**
     * Get IdAcordoCriptografado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdAcordoCriptografado()
    {
        return isset($this->IdAcordoCriptografado) ? $this->IdAcordoCriptografado : null;
    }
    /**
     * Set IdAcordoCriptografado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idAcordoCriptografado
     * @return \StructType\EnviaBoletoUra
     */
    public function setIdAcordoCriptografado($idAcordoCriptografado = null)
    {
        // validation for constraint: string
        if (!is_null($idAcordoCriptografado) && !is_string($idAcordoCriptografado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idAcordoCriptografado, true), gettype($idAcordoCriptografado)), __LINE__);
        }
        if (is_null($idAcordoCriptografado) || (is_array($idAcordoCriptografado) && empty($idAcordoCriptografado))) {
            unset($this->IdAcordoCriptografado);
        } else {
            $this->IdAcordoCriptografado = $idAcordoCriptografado;
        }
        return $this;
    }
    /**
     * Get IdBoleto value
     * @return int|null
     */
    public function getIdBoleto()
    {
        return $this->IdBoleto;
    }
    /**
     * Set IdBoleto value
     * @param int $idBoleto
     * @return \StructType\EnviaBoletoUra
     */
    public function setIdBoleto($idBoleto = null)
    {
        // validation for constraint: int
        if (!is_null($idBoleto) && !(is_int($idBoleto) || ctype_digit($idBoleto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idBoleto, true), gettype($idBoleto)), __LINE__);
        }
        $this->IdBoleto = $idBoleto;
        return $this;
    }
    /**
     * Get numParcela value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumParcela()
    {
        return isset($this->numParcela) ? $this->numParcela : null;
    }
    /**
     * Set numParcela value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numParcela
     * @return \StructType\EnviaBoletoUra
     */
    public function setNumParcela($numParcela = null)
    {
        // validation for constraint: string
        if (!is_null($numParcela) && !is_string($numParcela)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numParcela, true), gettype($numParcela)), __LINE__);
        }
        if (is_null($numParcela) || (is_array($numParcela) && empty($numParcela))) {
            unset($this->numParcela);
        } else {
            $this->numParcela = $numParcela;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\EnviaBoletoUra
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get telefone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefone()
    {
        return isset($this->telefone) ? $this->telefone : null;
    }
    /**
     * Set telefone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefone
     * @return \StructType\EnviaBoletoUra
     */
    public function setTelefone($telefone = null)
    {
        // validation for constraint: string
        if (!is_null($telefone) && !is_string($telefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefone, true), gettype($telefone)), __LINE__);
        }
        if (is_null($telefone) || (is_array($telefone) && empty($telefone))) {
            unset($this->telefone);
        } else {
            $this->telefone = $telefone;
        }
        return $this;
    }
    /**
     * Get IdPessoa value
     * @return int|null
     */
    public function getIdPessoa()
    {
        return $this->IdPessoa;
    }
    /**
     * Set IdPessoa value
     * @param int $idPessoa
     * @return \StructType\EnviaBoletoUra
     */
    public function setIdPessoa($idPessoa = null)
    {
        // validation for constraint: int
        if (!is_null($idPessoa) && !(is_int($idPessoa) || ctype_digit($idPessoa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPessoa, true), gettype($idPessoa)), __LINE__);
        }
        $this->IdPessoa = $idPessoa;
        return $this;
    }
    /**
     * Get IdCredor value
     * @return int|null
     */
    public function getIdCredor()
    {
        return $this->IdCredor;
    }
    /**
     * Set IdCredor value
     * @param int $idCredor
     * @return \StructType\EnviaBoletoUra
     */
    public function setIdCredor($idCredor = null)
    {
        // validation for constraint: int
        if (!is_null($idCredor) && !(is_int($idCredor) || ctype_digit($idCredor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCredor, true), gettype($idCredor)), __LINE__);
        }
        $this->IdCredor = $idCredor;
        return $this;
    }
    /**
     * Get BoletoOriginal value
     * @return bool|null
     */
    public function getBoletoOriginal()
    {
        return $this->BoletoOriginal;
    }
    /**
     * Set BoletoOriginal value
     * @param bool $boletoOriginal
     * @return \StructType\EnviaBoletoUra
     */
    public function setBoletoOriginal($boletoOriginal = null)
    {
        // validation for constraint: boolean
        if (!is_null($boletoOriginal) && !is_bool($boletoOriginal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($boletoOriginal, true), gettype($boletoOriginal)), __LINE__);
        }
        $this->BoletoOriginal = $boletoOriginal;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\EnviaBoletoUra
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
