<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnderecoType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EnderecoType
 * @subpackage Structs
 */
class EnderecoType extends AbstractStructBase
{
    /**
     * The Bairro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Bairro;
    /**
     * The Cep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cep;
    /**
     * The Complemento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Complemento;
    /**
     * The Logradouro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Logradouro;
    /**
     * The Municipio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Municipio;
    /**
     * The NumEndereco
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumEndereco;
    /**
     * The OrigemDados
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrigemDados;
    /**
     * The TipoEndereco
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEndereco;
    /**
     * The UF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UF;
    /**
     * Constructor method for EnderecoType
     * @uses EnderecoType::setBairro()
     * @uses EnderecoType::setCep()
     * @uses EnderecoType::setComplemento()
     * @uses EnderecoType::setLogradouro()
     * @uses EnderecoType::setMunicipio()
     * @uses EnderecoType::setNumEndereco()
     * @uses EnderecoType::setOrigemDados()
     * @uses EnderecoType::setTipoEndereco()
     * @uses EnderecoType::setUF()
     * @param string $bairro
     * @param string $cep
     * @param string $complemento
     * @param string $logradouro
     * @param string $municipio
     * @param string $numEndereco
     * @param int $origemDados
     * @param string $tipoEndereco
     * @param string $uF
     */
    public function __construct($bairro = null, $cep = null, $complemento = null, $logradouro = null, $municipio = null, $numEndereco = null, $origemDados = null, $tipoEndereco = null, $uF = null)
    {
        $this
            ->setBairro($bairro)
            ->setCep($cep)
            ->setComplemento($complemento)
            ->setLogradouro($logradouro)
            ->setMunicipio($municipio)
            ->setNumEndereco($numEndereco)
            ->setOrigemDados($origemDados)
            ->setTipoEndereco($tipoEndereco)
            ->setUF($uF);
    }
    /**
     * Get Bairro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBairro()
    {
        return isset($this->Bairro) ? $this->Bairro : null;
    }
    /**
     * Set Bairro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bairro
     * @return \StructType\EnderecoType
     */
    public function setBairro($bairro = null)
    {
        // validation for constraint: string
        if (!is_null($bairro) && !is_string($bairro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bairro, true), gettype($bairro)), __LINE__);
        }
        if (is_null($bairro) || (is_array($bairro) && empty($bairro))) {
            unset($this->Bairro);
        } else {
            $this->Bairro = $bairro;
        }
        return $this;
    }
    /**
     * Get Cep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCep()
    {
        return isset($this->Cep) ? $this->Cep : null;
    }
    /**
     * Set Cep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cep
     * @return \StructType\EnderecoType
     */
    public function setCep($cep = null)
    {
        // validation for constraint: string
        if (!is_null($cep) && !is_string($cep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cep, true), gettype($cep)), __LINE__);
        }
        if (is_null($cep) || (is_array($cep) && empty($cep))) {
            unset($this->Cep);
        } else {
            $this->Cep = $cep;
        }
        return $this;
    }
    /**
     * Get Complemento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComplemento()
    {
        return isset($this->Complemento) ? $this->Complemento : null;
    }
    /**
     * Set Complemento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $complemento
     * @return \StructType\EnderecoType
     */
    public function setComplemento($complemento = null)
    {
        // validation for constraint: string
        if (!is_null($complemento) && !is_string($complemento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($complemento, true), gettype($complemento)), __LINE__);
        }
        if (is_null($complemento) || (is_array($complemento) && empty($complemento))) {
            unset($this->Complemento);
        } else {
            $this->Complemento = $complemento;
        }
        return $this;
    }
    /**
     * Get Logradouro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogradouro()
    {
        return isset($this->Logradouro) ? $this->Logradouro : null;
    }
    /**
     * Set Logradouro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logradouro
     * @return \StructType\EnderecoType
     */
    public function setLogradouro($logradouro = null)
    {
        // validation for constraint: string
        if (!is_null($logradouro) && !is_string($logradouro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logradouro, true), gettype($logradouro)), __LINE__);
        }
        if (is_null($logradouro) || (is_array($logradouro) && empty($logradouro))) {
            unset($this->Logradouro);
        } else {
            $this->Logradouro = $logradouro;
        }
        return $this;
    }
    /**
     * Get Municipio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMunicipio()
    {
        return isset($this->Municipio) ? $this->Municipio : null;
    }
    /**
     * Set Municipio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $municipio
     * @return \StructType\EnderecoType
     */
    public function setMunicipio($municipio = null)
    {
        // validation for constraint: string
        if (!is_null($municipio) && !is_string($municipio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($municipio, true), gettype($municipio)), __LINE__);
        }
        if (is_null($municipio) || (is_array($municipio) && empty($municipio))) {
            unset($this->Municipio);
        } else {
            $this->Municipio = $municipio;
        }
        return $this;
    }
    /**
     * Get NumEndereco value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumEndereco()
    {
        return isset($this->NumEndereco) ? $this->NumEndereco : null;
    }
    /**
     * Set NumEndereco value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numEndereco
     * @return \StructType\EnderecoType
     */
    public function setNumEndereco($numEndereco = null)
    {
        // validation for constraint: string
        if (!is_null($numEndereco) && !is_string($numEndereco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numEndereco, true), gettype($numEndereco)), __LINE__);
        }
        if (is_null($numEndereco) || (is_array($numEndereco) && empty($numEndereco))) {
            unset($this->NumEndereco);
        } else {
            $this->NumEndereco = $numEndereco;
        }
        return $this;
    }
    /**
     * Get OrigemDados value
     * @return int|null
     */
    public function getOrigemDados()
    {
        return $this->OrigemDados;
    }
    /**
     * Set OrigemDados value
     * @param int $origemDados
     * @return \StructType\EnderecoType
     */
    public function setOrigemDados($origemDados = null)
    {
        // validation for constraint: int
        if (!is_null($origemDados) && !(is_int($origemDados) || ctype_digit($origemDados))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($origemDados, true), gettype($origemDados)), __LINE__);
        }
        $this->OrigemDados = $origemDados;
        return $this;
    }
    /**
     * Get TipoEndereco value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEndereco()
    {
        return isset($this->TipoEndereco) ? $this->TipoEndereco : null;
    }
    /**
     * Set TipoEndereco value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\EnumTipoEndereco::valueIsValid()
     * @uses \EnumType\EnumTipoEndereco::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoEndereco
     * @return \StructType\EnderecoType
     */
    public function setTipoEndereco($tipoEndereco = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTipoEndereco::valueIsValid($tipoEndereco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTipoEndereco', is_array($tipoEndereco) ? implode(', ', $tipoEndereco) : var_export($tipoEndereco, true), implode(', ', \EnumType\EnumTipoEndereco::getValidValues())), __LINE__);
        }
        if (is_null($tipoEndereco) || (is_array($tipoEndereco) && empty($tipoEndereco))) {
            unset($this->TipoEndereco);
        } else {
            $this->TipoEndereco = $tipoEndereco;
        }
        return $this;
    }
    /**
     * Get UF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUF()
    {
        return isset($this->UF) ? $this->UF : null;
    }
    /**
     * Set UF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uF
     * @return \StructType\EnderecoType
     */
    public function setUF($uF = null)
    {
        // validation for constraint: string
        if (!is_null($uF) && !is_string($uF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uF, true), gettype($uF)), __LINE__);
        }
        if (is_null($uF) || (is_array($uF) && empty($uF))) {
            unset($this->UF);
        } else {
            $this->UF = $uF;
        }
        return $this;
    }
}
