<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmitirBoletoApi StructType
 * @subpackage Structs
 */
class EmitirBoletoApi extends AbstractStructBase
{
    /**
     * The parcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $parcela;
    /**
     * The IdAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdAcordo;
    /**
     * The IdCredor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCredor;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for EmitirBoletoApi
     * @uses EmitirBoletoApi::setParcela()
     * @uses EmitirBoletoApi::setIdAcordo()
     * @uses EmitirBoletoApi::setIdCredor()
     * @uses EmitirBoletoApi::setToken()
     * @param int $parcela
     * @param int $idAcordo
     * @param int $idCredor
     * @param string $token
     */
    public function __construct($parcela = null, $idAcordo = null, $idCredor = null, $token = null)
    {
        $this
            ->setParcela($parcela)
            ->setIdAcordo($idAcordo)
            ->setIdCredor($idCredor)
            ->setToken($token);
    }
    /**
     * Get parcela value
     * @return int|null
     */
    public function getParcela()
    {
        return $this->parcela;
    }
    /**
     * Set parcela value
     * @param int $parcela
     * @return \StructType\EmitirBoletoApi
     */
    public function setParcela($parcela = null)
    {
        // validation for constraint: int
        if (!is_null($parcela) && !(is_int($parcela) || ctype_digit($parcela))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcela, true), gettype($parcela)), __LINE__);
        }
        $this->parcela = $parcela;
        return $this;
    }
    /**
     * Get IdAcordo value
     * @return int|null
     */
    public function getIdAcordo()
    {
        return $this->IdAcordo;
    }
    /**
     * Set IdAcordo value
     * @param int $idAcordo
     * @return \StructType\EmitirBoletoApi
     */
    public function setIdAcordo($idAcordo = null)
    {
        // validation for constraint: int
        if (!is_null($idAcordo) && !(is_int($idAcordo) || ctype_digit($idAcordo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idAcordo, true), gettype($idAcordo)), __LINE__);
        }
        $this->IdAcordo = $idAcordo;
        return $this;
    }
    /**
     * Get IdCredor value
     * @return int|null
     */
    public function getIdCredor()
    {
        return $this->IdCredor;
    }
    /**
     * Set IdCredor value
     * @param int $idCredor
     * @return \StructType\EmitirBoletoApi
     */
    public function setIdCredor($idCredor = null)
    {
        // validation for constraint: int
        if (!is_null($idCredor) && !(is_int($idCredor) || ctype_digit($idCredor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCredor, true), gettype($idCredor)), __LINE__);
        }
        $this->IdCredor = $idCredor;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\EmitirBoletoApi
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
