<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmissaoBoletoTypePortal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EmissaoBoletoTypePortal
 * @subpackage Structs
 */
class EmissaoBoletoTypePortal extends AbstractStructBase
{
    /**
     * The RedirectUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RedirectUrl;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Url;
    /**
     * Constructor method for EmissaoBoletoTypePortal
     * @uses EmissaoBoletoTypePortal::setRedirectUrl()
     * @uses EmissaoBoletoTypePortal::setUrl()
     * @param bool $redirectUrl
     * @param string $url
     */
    public function __construct($redirectUrl = null, $url = null)
    {
        $this
            ->setRedirectUrl($redirectUrl)
            ->setUrl($url);
    }
    /**
     * Get RedirectUrl value
     * @return bool|null
     */
    public function getRedirectUrl()
    {
        return $this->RedirectUrl;
    }
    /**
     * Set RedirectUrl value
     * @param bool $redirectUrl
     * @return \StructType\EmissaoBoletoTypePortal
     */
    public function setRedirectUrl($redirectUrl = null)
    {
        // validation for constraint: boolean
        if (!is_null($redirectUrl) && !is_bool($redirectUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($redirectUrl, true), gettype($redirectUrl)), __LINE__);
        }
        $this->RedirectUrl = $redirectUrl;
        return $this;
    }
    /**
     * Get Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->Url) ? $this->Url : null;
    }
    /**
     * Set Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \StructType\EmissaoBoletoTypePortal
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->Url);
        } else {
            $this->Url = $url;
        }
        return $this;
    }
}
