<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EmailType
 * @subpackage Structs
 */
class EmailType extends AbstractStructBase
{
    /**
     * The EnderecoEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnderecoEmail;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacao;
    /**
     * The OrigemDados
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrigemDados;
    /**
     * Constructor method for EmailType
     * @uses EmailType::setEnderecoEmail()
     * @uses EmailType::setObservacao()
     * @uses EmailType::setOrigemDados()
     * @param string $enderecoEmail
     * @param string $observacao
     * @param int $origemDados
     */
    public function __construct($enderecoEmail = null, $observacao = null, $origemDados = null)
    {
        $this
            ->setEnderecoEmail($enderecoEmail)
            ->setObservacao($observacao)
            ->setOrigemDados($origemDados);
    }
    /**
     * Get EnderecoEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnderecoEmail()
    {
        return isset($this->EnderecoEmail) ? $this->EnderecoEmail : null;
    }
    /**
     * Set EnderecoEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enderecoEmail
     * @return \StructType\EmailType
     */
    public function setEnderecoEmail($enderecoEmail = null)
    {
        // validation for constraint: string
        if (!is_null($enderecoEmail) && !is_string($enderecoEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enderecoEmail, true), gettype($enderecoEmail)), __LINE__);
        }
        if (is_null($enderecoEmail) || (is_array($enderecoEmail) && empty($enderecoEmail))) {
            unset($this->EnderecoEmail);
        } else {
            $this->EnderecoEmail = $enderecoEmail;
        }
        return $this;
    }
    /**
     * Get Observacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacao()
    {
        return isset($this->Observacao) ? $this->Observacao : null;
    }
    /**
     * Set Observacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacao
     * @return \StructType\EmailType
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        if (is_null($observacao) || (is_array($observacao) && empty($observacao))) {
            unset($this->Observacao);
        } else {
            $this->Observacao = $observacao;
        }
        return $this;
    }
    /**
     * Get OrigemDados value
     * @return int|null
     */
    public function getOrigemDados()
    {
        return $this->OrigemDados;
    }
    /**
     * Set OrigemDados value
     * @param int $origemDados
     * @return \StructType\EmailType
     */
    public function setOrigemDados($origemDados = null)
    {
        // validation for constraint: int
        if (!is_null($origemDados) && !(is_int($origemDados) || ctype_digit($origemDados))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($origemDados, true), gettype($origemDados)), __LINE__);
        }
        $this->OrigemDados = $origemDados;
        return $this;
    }
}
