<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DevolucaoParcialType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DevolucaoParcialType
 * @subpackage Structs
 */
class DevolucaoParcialType extends AbstractStructBase
{
    /**
     * The DataDevolucao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataDevolucao;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Numero;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacao;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Valor;
    /**
     * The ValorDevolucao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorDevolucao;
    /**
     * The Vencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vencimento;
    /**
     * Constructor method for DevolucaoParcialType
     * @uses DevolucaoParcialType::setDataDevolucao()
     * @uses DevolucaoParcialType::setNumero()
     * @uses DevolucaoParcialType::setObservacao()
     * @uses DevolucaoParcialType::setValor()
     * @uses DevolucaoParcialType::setValorDevolucao()
     * @uses DevolucaoParcialType::setVencimento()
     * @param string $dataDevolucao
     * @param string $numero
     * @param string $observacao
     * @param float $valor
     * @param float $valorDevolucao
     * @param string $vencimento
     */
    public function __construct($dataDevolucao = null, $numero = null, $observacao = null, $valor = null, $valorDevolucao = null, $vencimento = null)
    {
        $this
            ->setDataDevolucao($dataDevolucao)
            ->setNumero($numero)
            ->setObservacao($observacao)
            ->setValor($valor)
            ->setValorDevolucao($valorDevolucao)
            ->setVencimento($vencimento);
    }
    /**
     * Get DataDevolucao value
     * @return string|null
     */
    public function getDataDevolucao()
    {
        return $this->DataDevolucao;
    }
    /**
     * Set DataDevolucao value
     * @param string $dataDevolucao
     * @return \StructType\DevolucaoParcialType
     */
    public function setDataDevolucao($dataDevolucao = null)
    {
        // validation for constraint: string
        if (!is_null($dataDevolucao) && !is_string($dataDevolucao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataDevolucao, true), gettype($dataDevolucao)), __LINE__);
        }
        $this->DataDevolucao = $dataDevolucao;
        return $this;
    }
    /**
     * Get Numero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumero()
    {
        return isset($this->Numero) ? $this->Numero : null;
    }
    /**
     * Set Numero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numero
     * @return \StructType\DevolucaoParcialType
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        if (is_null($numero) || (is_array($numero) && empty($numero))) {
            unset($this->Numero);
        } else {
            $this->Numero = $numero;
        }
        return $this;
    }
    /**
     * Get Observacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacao()
    {
        return isset($this->Observacao) ? $this->Observacao : null;
    }
    /**
     * Set Observacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacao
     * @return \StructType\DevolucaoParcialType
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        if (is_null($observacao) || (is_array($observacao) && empty($observacao))) {
            unset($this->Observacao);
        } else {
            $this->Observacao = $observacao;
        }
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\DevolucaoParcialType
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get ValorDevolucao value
     * @return float|null
     */
    public function getValorDevolucao()
    {
        return $this->ValorDevolucao;
    }
    /**
     * Set ValorDevolucao value
     * @param float $valorDevolucao
     * @return \StructType\DevolucaoParcialType
     */
    public function setValorDevolucao($valorDevolucao = null)
    {
        // validation for constraint: float
        if (!is_null($valorDevolucao) && !(is_float($valorDevolucao) || is_numeric($valorDevolucao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorDevolucao, true), gettype($valorDevolucao)), __LINE__);
        }
        $this->ValorDevolucao = $valorDevolucao;
        return $this;
    }
    /**
     * Get Vencimento value
     * @return string|null
     */
    public function getVencimento()
    {
        return $this->Vencimento;
    }
    /**
     * Set Vencimento value
     * @param string $vencimento
     * @return \StructType\DevolucaoParcialType
     */
    public function setVencimento($vencimento = null)
    {
        // validation for constraint: string
        if (!is_null($vencimento) && !is_string($vencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimento, true), gettype($vencimento)), __LINE__);
        }
        $this->Vencimento = $vencimento;
        return $this;
    }
}
