<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContratoTypePortal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContratoTypePortal
 * @subpackage Structs
 */
class ContratoTypePortal extends AbstractStructBase
{
    /**
     * The Atraso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Atraso;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Data;
    /**
     * The Enquadrado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Enquadrado;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IdNegociacaoAtiva
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdNegociacaoAtiva;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Numero;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacao;
    /**
     * The Parcelas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaCalculoType
     */
    public $Parcelas;
    /**
     * The Plano
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Plano;
    /**
     * The Produto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Produto;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Valor;
    /**
     * The listaProduto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProdutoTypePortal
     */
    public $listaProduto;
    /**
     * Constructor method for ContratoTypePortal
     * @uses ContratoTypePortal::setAtraso()
     * @uses ContratoTypePortal::setData()
     * @uses ContratoTypePortal::setEnquadrado()
     * @uses ContratoTypePortal::setId()
     * @uses ContratoTypePortal::setIdNegociacaoAtiva()
     * @uses ContratoTypePortal::setNumero()
     * @uses ContratoTypePortal::setObservacao()
     * @uses ContratoTypePortal::setParcelas()
     * @uses ContratoTypePortal::setPlano()
     * @uses ContratoTypePortal::setProduto()
     * @uses ContratoTypePortal::setValor()
     * @uses ContratoTypePortal::setListaProduto()
     * @param int $atraso
     * @param string $data
     * @param bool $enquadrado
     * @param int $id
     * @param int $idNegociacaoAtiva
     * @param string $numero
     * @param string $observacao
     * @param \ArrayType\ArrayOfParcelaCalculoType $parcelas
     * @param int $plano
     * @param string $produto
     * @param float $valor
     * @param \ArrayType\ArrayOfProdutoTypePortal $listaProduto
     */
    public function __construct($atraso = null, $data = null, $enquadrado = null, $id = null, $idNegociacaoAtiva = null, $numero = null, $observacao = null, \ArrayType\ArrayOfParcelaCalculoType $parcelas = null, $plano = null, $produto = null, $valor = null, \ArrayType\ArrayOfProdutoTypePortal $listaProduto = null)
    {
        $this
            ->setAtraso($atraso)
            ->setData($data)
            ->setEnquadrado($enquadrado)
            ->setId($id)
            ->setIdNegociacaoAtiva($idNegociacaoAtiva)
            ->setNumero($numero)
            ->setObservacao($observacao)
            ->setParcelas($parcelas)
            ->setPlano($plano)
            ->setProduto($produto)
            ->setValor($valor)
            ->setListaProduto($listaProduto);
    }
    /**
     * Get Atraso value
     * @return int|null
     */
    public function getAtraso()
    {
        return $this->Atraso;
    }
    /**
     * Set Atraso value
     * @param int $atraso
     * @return \StructType\ContratoTypePortal
     */
    public function setAtraso($atraso = null)
    {
        // validation for constraint: int
        if (!is_null($atraso) && !(is_int($atraso) || ctype_digit($atraso))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($atraso, true), gettype($atraso)), __LINE__);
        }
        $this->Atraso = $atraso;
        return $this;
    }
    /**
     * Get Data value
     * @return string|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \StructType\ContratoTypePortal
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Enquadrado value
     * @return bool|null
     */
    public function getEnquadrado()
    {
        return $this->Enquadrado;
    }
    /**
     * Set Enquadrado value
     * @param bool $enquadrado
     * @return \StructType\ContratoTypePortal
     */
    public function setEnquadrado($enquadrado = null)
    {
        // validation for constraint: boolean
        if (!is_null($enquadrado) && !is_bool($enquadrado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enquadrado, true), gettype($enquadrado)), __LINE__);
        }
        $this->Enquadrado = $enquadrado;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ContratoTypePortal
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IdNegociacaoAtiva value
     * @return int|null
     */
    public function getIdNegociacaoAtiva()
    {
        return $this->IdNegociacaoAtiva;
    }
    /**
     * Set IdNegociacaoAtiva value
     * @param int $idNegociacaoAtiva
     * @return \StructType\ContratoTypePortal
     */
    public function setIdNegociacaoAtiva($idNegociacaoAtiva = null)
    {
        // validation for constraint: int
        if (!is_null($idNegociacaoAtiva) && !(is_int($idNegociacaoAtiva) || ctype_digit($idNegociacaoAtiva))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idNegociacaoAtiva, true), gettype($idNegociacaoAtiva)), __LINE__);
        }
        $this->IdNegociacaoAtiva = $idNegociacaoAtiva;
        return $this;
    }
    /**
     * Get Numero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumero()
    {
        return isset($this->Numero) ? $this->Numero : null;
    }
    /**
     * Set Numero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numero
     * @return \StructType\ContratoTypePortal
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        if (is_null($numero) || (is_array($numero) && empty($numero))) {
            unset($this->Numero);
        } else {
            $this->Numero = $numero;
        }
        return $this;
    }
    /**
     * Get Observacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacao()
    {
        return isset($this->Observacao) ? $this->Observacao : null;
    }
    /**
     * Set Observacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacao
     * @return \StructType\ContratoTypePortal
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        if (is_null($observacao) || (is_array($observacao) && empty($observacao))) {
            unset($this->Observacao);
        } else {
            $this->Observacao = $observacao;
        }
        return $this;
    }
    /**
     * Get Parcelas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaCalculoType|null
     */
    public function getParcelas()
    {
        return isset($this->Parcelas) ? $this->Parcelas : null;
    }
    /**
     * Set Parcelas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaCalculoType $parcelas
     * @return \StructType\ContratoTypePortal
     */
    public function setParcelas(\ArrayType\ArrayOfParcelaCalculoType $parcelas = null)
    {
        if (is_null($parcelas) || (is_array($parcelas) && empty($parcelas))) {
            unset($this->Parcelas);
        } else {
            $this->Parcelas = $parcelas;
        }
        return $this;
    }
    /**
     * Get Plano value
     * @return int|null
     */
    public function getPlano()
    {
        return $this->Plano;
    }
    /**
     * Set Plano value
     * @param int $plano
     * @return \StructType\ContratoTypePortal
     */
    public function setPlano($plano = null)
    {
        // validation for constraint: int
        if (!is_null($plano) && !(is_int($plano) || ctype_digit($plano))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($plano, true), gettype($plano)), __LINE__);
        }
        $this->Plano = $plano;
        return $this;
    }
    /**
     * Get Produto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProduto()
    {
        return isset($this->Produto) ? $this->Produto : null;
    }
    /**
     * Set Produto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $produto
     * @return \StructType\ContratoTypePortal
     */
    public function setProduto($produto = null)
    {
        // validation for constraint: string
        if (!is_null($produto) && !is_string($produto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($produto, true), gettype($produto)), __LINE__);
        }
        if (is_null($produto) || (is_array($produto) && empty($produto))) {
            unset($this->Produto);
        } else {
            $this->Produto = $produto;
        }
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\ContratoTypePortal
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get listaProduto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProdutoTypePortal|null
     */
    public function getListaProduto()
    {
        return isset($this->listaProduto) ? $this->listaProduto : null;
    }
    /**
     * Set listaProduto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProdutoTypePortal $listaProduto
     * @return \StructType\ContratoTypePortal
     */
    public function setListaProduto(\ArrayType\ArrayOfProdutoTypePortal $listaProduto = null)
    {
        if (is_null($listaProduto) || (is_array($listaProduto) && empty($listaProduto))) {
            unset($this->listaProduto);
        } else {
            $this->listaProduto = $listaProduto;
        }
        return $this;
    }
}
