<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContratoTypePix StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContratoTypePix
 * @subpackage Structs
 */
class ContratoTypePix extends AbstractStructBase
{
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Numero;
    /**
     * The Parcelas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaTypePix
     */
    public $Parcelas;
    /**
     * Constructor method for ContratoTypePix
     * @uses ContratoTypePix::setNumero()
     * @uses ContratoTypePix::setParcelas()
     * @param string $numero
     * @param \ArrayType\ArrayOfParcelaTypePix $parcelas
     */
    public function __construct($numero = null, \ArrayType\ArrayOfParcelaTypePix $parcelas = null)
    {
        $this
            ->setNumero($numero)
            ->setParcelas($parcelas);
    }
    /**
     * Get Numero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumero()
    {
        return isset($this->Numero) ? $this->Numero : null;
    }
    /**
     * Set Numero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numero
     * @return \StructType\ContratoTypePix
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        if (is_null($numero) || (is_array($numero) && empty($numero))) {
            unset($this->Numero);
        } else {
            $this->Numero = $numero;
        }
        return $this;
    }
    /**
     * Get Parcelas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaTypePix|null
     */
    public function getParcelas()
    {
        return isset($this->Parcelas) ? $this->Parcelas : null;
    }
    /**
     * Set Parcelas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaTypePix $parcelas
     * @return \StructType\ContratoTypePix
     */
    public function setParcelas(\ArrayType\ArrayOfParcelaTypePix $parcelas = null)
    {
        if (is_null($parcelas) || (is_array($parcelas) && empty($parcelas))) {
            unset($this->Parcelas);
        } else {
            $this->Parcelas = $parcelas;
        }
        return $this;
    }
}
