<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContratoType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContratoType
 * @subpackage Structs
 */
class ContratoType extends AbstractStructBase
{
    /**
     * The DataContrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataContrato;
    /**
     * The Filial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Filial;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Numero;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacao;
    /**
     * The Plano
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Plano;
    /**
     * The Regiao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Regiao;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Valor;
    /**
     * Constructor method for ContratoType
     * @uses ContratoType::setDataContrato()
     * @uses ContratoType::setFilial()
     * @uses ContratoType::setNumero()
     * @uses ContratoType::setObservacao()
     * @uses ContratoType::setPlano()
     * @uses ContratoType::setRegiao()
     * @uses ContratoType::setValor()
     * @param string $dataContrato
     * @param string $filial
     * @param string $numero
     * @param string $observacao
     * @param int $plano
     * @param string $regiao
     * @param float $valor
     */
    public function __construct($dataContrato = null, $filial = null, $numero = null, $observacao = null, $plano = null, $regiao = null, $valor = null)
    {
        $this
            ->setDataContrato($dataContrato)
            ->setFilial($filial)
            ->setNumero($numero)
            ->setObservacao($observacao)
            ->setPlano($plano)
            ->setRegiao($regiao)
            ->setValor($valor);
    }
    /**
     * Get DataContrato value
     * @return string|null
     */
    public function getDataContrato()
    {
        return $this->DataContrato;
    }
    /**
     * Set DataContrato value
     * @param string $dataContrato
     * @return \StructType\ContratoType
     */
    public function setDataContrato($dataContrato = null)
    {
        // validation for constraint: string
        if (!is_null($dataContrato) && !is_string($dataContrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataContrato, true), gettype($dataContrato)), __LINE__);
        }
        $this->DataContrato = $dataContrato;
        return $this;
    }
    /**
     * Get Filial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilial()
    {
        return isset($this->Filial) ? $this->Filial : null;
    }
    /**
     * Set Filial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filial
     * @return \StructType\ContratoType
     */
    public function setFilial($filial = null)
    {
        // validation for constraint: string
        if (!is_null($filial) && !is_string($filial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filial, true), gettype($filial)), __LINE__);
        }
        if (is_null($filial) || (is_array($filial) && empty($filial))) {
            unset($this->Filial);
        } else {
            $this->Filial = $filial;
        }
        return $this;
    }
    /**
     * Get Numero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumero()
    {
        return isset($this->Numero) ? $this->Numero : null;
    }
    /**
     * Set Numero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numero
     * @return \StructType\ContratoType
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        if (is_null($numero) || (is_array($numero) && empty($numero))) {
            unset($this->Numero);
        } else {
            $this->Numero = $numero;
        }
        return $this;
    }
    /**
     * Get Observacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacao()
    {
        return isset($this->Observacao) ? $this->Observacao : null;
    }
    /**
     * Set Observacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacao
     * @return \StructType\ContratoType
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        if (is_null($observacao) || (is_array($observacao) && empty($observacao))) {
            unset($this->Observacao);
        } else {
            $this->Observacao = $observacao;
        }
        return $this;
    }
    /**
     * Get Plano value
     * @return int|null
     */
    public function getPlano()
    {
        return $this->Plano;
    }
    /**
     * Set Plano value
     * @param int $plano
     * @return \StructType\ContratoType
     */
    public function setPlano($plano = null)
    {
        // validation for constraint: int
        if (!is_null($plano) && !(is_int($plano) || ctype_digit($plano))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($plano, true), gettype($plano)), __LINE__);
        }
        $this->Plano = $plano;
        return $this;
    }
    /**
     * Get Regiao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegiao()
    {
        return isset($this->Regiao) ? $this->Regiao : null;
    }
    /**
     * Set Regiao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regiao
     * @return \StructType\ContratoType
     */
    public function setRegiao($regiao = null)
    {
        // validation for constraint: string
        if (!is_null($regiao) && !is_string($regiao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regiao, true), gettype($regiao)), __LINE__);
        }
        if (is_null($regiao) || (is_array($regiao) && empty($regiao))) {
            unset($this->Regiao);
        } else {
            $this->Regiao = $regiao;
        }
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\ContratoType
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
}
