<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContratoRenegResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContratoRenegResponse
 * @subpackage Structs
 */
class ContratoRenegResponse extends ContratoRenegType
{
    /**
     * The Parcelas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaRenegResponse
     */
    public $Parcelas;
    /**
     * The Produtos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProdutoRenegResponse
     */
    public $Produtos;
    /**
     * Constructor method for ContratoRenegResponse
     * @uses ContratoRenegResponse::setParcelas()
     * @uses ContratoRenegResponse::setProdutos()
     * @param \ArrayType\ArrayOfParcelaRenegResponse $parcelas
     * @param \ArrayType\ArrayOfProdutoRenegResponse $produtos
     */
    public function __construct(\ArrayType\ArrayOfParcelaRenegResponse $parcelas = null, \ArrayType\ArrayOfProdutoRenegResponse $produtos = null)
    {
        $this
            ->setParcelas($parcelas)
            ->setProdutos($produtos);
    }
    /**
     * Get Parcelas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaRenegResponse|null
     */
    public function getParcelas()
    {
        return isset($this->Parcelas) ? $this->Parcelas : null;
    }
    /**
     * Set Parcelas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaRenegResponse $parcelas
     * @return \StructType\ContratoRenegResponse
     */
    public function setParcelas(\ArrayType\ArrayOfParcelaRenegResponse $parcelas = null)
    {
        if (is_null($parcelas) || (is_array($parcelas) && empty($parcelas))) {
            unset($this->Parcelas);
        } else {
            $this->Parcelas = $parcelas;
        }
        return $this;
    }
    /**
     * Get Produtos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProdutoRenegResponse|null
     */
    public function getProdutos()
    {
        return isset($this->Produtos) ? $this->Produtos : null;
    }
    /**
     * Set Produtos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProdutoRenegResponse $produtos
     * @return \StructType\ContratoRenegResponse
     */
    public function setProdutos(\ArrayType\ArrayOfProdutoRenegResponse $produtos = null)
    {
        if (is_null($produtos) || (is_array($produtos) && empty($produtos))) {
            unset($this->Produtos);
        } else {
            $this->Produtos = $produtos;
        }
        return $this;
    }
}
