<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultarDadosPix StructType
 * @subpackage Structs
 */
class ConsultarDadosPix extends AbstractStructBase
{
    /**
     * The IdPix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdPix;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for ConsultarDadosPix
     * @uses ConsultarDadosPix::setIdPix()
     * @uses ConsultarDadosPix::setToken()
     * @param int $idPix
     * @param string $token
     */
    public function __construct($idPix = null, $token = null)
    {
        $this
            ->setIdPix($idPix)
            ->setToken($token);
    }
    /**
     * Get IdPix value
     * @return int|null
     */
    public function getIdPix()
    {
        return $this->IdPix;
    }
    /**
     * Set IdPix value
     * @param int $idPix
     * @return \StructType\ConsultarDadosPix
     */
    public function setIdPix($idPix = null)
    {
        // validation for constraint: int
        if (!is_null($idPix) && !(is_int($idPix) || ctype_digit($idPix))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPix, true), gettype($idPix)), __LINE__);
        }
        $this->IdPix = $idPix;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\ConsultarDadosPix
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
