<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultarContratoCampoPortal StructType
 * @subpackage Structs
 */
class ConsultarContratoCampoPortal extends AbstractStructBase
{
    /**
     * The IdContrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdContrato;
    /**
     * The Ordem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordem;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for ConsultarContratoCampoPortal
     * @uses ConsultarContratoCampoPortal::setIdContrato()
     * @uses ConsultarContratoCampoPortal::setOrdem()
     * @uses ConsultarContratoCampoPortal::setToken()
     * @param int $idContrato
     * @param int $ordem
     * @param string $token
     */
    public function __construct($idContrato = null, $ordem = null, $token = null)
    {
        $this
            ->setIdContrato($idContrato)
            ->setOrdem($ordem)
            ->setToken($token);
    }
    /**
     * Get IdContrato value
     * @return int|null
     */
    public function getIdContrato()
    {
        return $this->IdContrato;
    }
    /**
     * Set IdContrato value
     * @param int $idContrato
     * @return \StructType\ConsultarContratoCampoPortal
     */
    public function setIdContrato($idContrato = null)
    {
        // validation for constraint: int
        if (!is_null($idContrato) && !(is_int($idContrato) || ctype_digit($idContrato))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idContrato, true), gettype($idContrato)), __LINE__);
        }
        $this->IdContrato = $idContrato;
        return $this;
    }
    /**
     * Get Ordem value
     * @return int|null
     */
    public function getOrdem()
    {
        return $this->Ordem;
    }
    /**
     * Set Ordem value
     * @param int $ordem
     * @return \StructType\ConsultarContratoCampoPortal
     */
    public function setOrdem($ordem = null)
    {
        // validation for constraint: int
        if (!is_null($ordem) && !(is_int($ordem) || ctype_digit($ordem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordem, true), gettype($ordem)), __LINE__);
        }
        $this->Ordem = $ordem;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\ConsultarContratoCampoPortal
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
