<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultarAtualizacaoCadastral StructType
 * @subpackage Structs
 */
class ConsultarAtualizacaoCadastral extends AbstractStructBase
{
    /**
     * The DataInicial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataInicial;
    /**
     * The DataFinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataFinal;
    /**
     * The booEndereco
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $booEndereco;
    /**
     * The booTelefone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $booTelefone;
    /**
     * The booEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $booEmail;
    /**
     * The TipoOrigem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoOrigem;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for ConsultarAtualizacaoCadastral
     * @uses ConsultarAtualizacaoCadastral::setDataInicial()
     * @uses ConsultarAtualizacaoCadastral::setDataFinal()
     * @uses ConsultarAtualizacaoCadastral::setBooEndereco()
     * @uses ConsultarAtualizacaoCadastral::setBooTelefone()
     * @uses ConsultarAtualizacaoCadastral::setBooEmail()
     * @uses ConsultarAtualizacaoCadastral::setTipoOrigem()
     * @uses ConsultarAtualizacaoCadastral::setToken()
     * @param string $dataInicial
     * @param string $dataFinal
     * @param bool $booEndereco
     * @param bool $booTelefone
     * @param bool $booEmail
     * @param string $tipoOrigem
     * @param string $token
     */
    public function __construct($dataInicial = null, $dataFinal = null, $booEndereco = null, $booTelefone = null, $booEmail = null, $tipoOrigem = null, $token = null)
    {
        $this
            ->setDataInicial($dataInicial)
            ->setDataFinal($dataFinal)
            ->setBooEndereco($booEndereco)
            ->setBooTelefone($booTelefone)
            ->setBooEmail($booEmail)
            ->setTipoOrigem($tipoOrigem)
            ->setToken($token);
    }
    /**
     * Get DataInicial value
     * @return string|null
     */
    public function getDataInicial()
    {
        return $this->DataInicial;
    }
    /**
     * Set DataInicial value
     * @param string $dataInicial
     * @return \StructType\ConsultarAtualizacaoCadastral
     */
    public function setDataInicial($dataInicial = null)
    {
        // validation for constraint: string
        if (!is_null($dataInicial) && !is_string($dataInicial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInicial, true), gettype($dataInicial)), __LINE__);
        }
        $this->DataInicial = $dataInicial;
        return $this;
    }
    /**
     * Get DataFinal value
     * @return string|null
     */
    public function getDataFinal()
    {
        return $this->DataFinal;
    }
    /**
     * Set DataFinal value
     * @param string $dataFinal
     * @return \StructType\ConsultarAtualizacaoCadastral
     */
    public function setDataFinal($dataFinal = null)
    {
        // validation for constraint: string
        if (!is_null($dataFinal) && !is_string($dataFinal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataFinal, true), gettype($dataFinal)), __LINE__);
        }
        $this->DataFinal = $dataFinal;
        return $this;
    }
    /**
     * Get booEndereco value
     * @return bool|null
     */
    public function getBooEndereco()
    {
        return $this->booEndereco;
    }
    /**
     * Set booEndereco value
     * @param bool $booEndereco
     * @return \StructType\ConsultarAtualizacaoCadastral
     */
    public function setBooEndereco($booEndereco = null)
    {
        // validation for constraint: boolean
        if (!is_null($booEndereco) && !is_bool($booEndereco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($booEndereco, true), gettype($booEndereco)), __LINE__);
        }
        $this->booEndereco = $booEndereco;
        return $this;
    }
    /**
     * Get booTelefone value
     * @return bool|null
     */
    public function getBooTelefone()
    {
        return $this->booTelefone;
    }
    /**
     * Set booTelefone value
     * @param bool $booTelefone
     * @return \StructType\ConsultarAtualizacaoCadastral
     */
    public function setBooTelefone($booTelefone = null)
    {
        // validation for constraint: boolean
        if (!is_null($booTelefone) && !is_bool($booTelefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($booTelefone, true), gettype($booTelefone)), __LINE__);
        }
        $this->booTelefone = $booTelefone;
        return $this;
    }
    /**
     * Get booEmail value
     * @return bool|null
     */
    public function getBooEmail()
    {
        return $this->booEmail;
    }
    /**
     * Set booEmail value
     * @param bool $booEmail
     * @return \StructType\ConsultarAtualizacaoCadastral
     */
    public function setBooEmail($booEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($booEmail) && !is_bool($booEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($booEmail, true), gettype($booEmail)), __LINE__);
        }
        $this->booEmail = $booEmail;
        return $this;
    }
    /**
     * Get TipoOrigem value
     * @return string|null
     */
    public function getTipoOrigem()
    {
        return $this->TipoOrigem;
    }
    /**
     * Set TipoOrigem value
     * @uses \EnumType\EnumTipoOrigem::valueIsValid()
     * @uses \EnumType\EnumTipoOrigem::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoOrigem
     * @return \StructType\ConsultarAtualizacaoCadastral
     */
    public function setTipoOrigem($tipoOrigem = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTipoOrigem::valueIsValid($tipoOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTipoOrigem', is_array($tipoOrigem) ? implode(', ', $tipoOrigem) : var_export($tipoOrigem, true), implode(', ', \EnumType\EnumTipoOrigem::getValidValues())), __LINE__);
        }
        $this->TipoOrigem = $tipoOrigem;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\ConsultarAtualizacaoCadastral
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
