<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClienteAcordoResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClienteAcordoResponse
 * @subpackage Structs
 */
class ClienteAcordoResponse extends AcordoResponse
{
    /**
     * The Assessoria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AssessoriaResponse
     */
    public $Assessoria;
    /**
     * The CPFCNPJ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPFCNPJ;
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * Constructor method for ClienteAcordoResponse
     * @uses ClienteAcordoResponse::setAssessoria()
     * @uses ClienteAcordoResponse::setCPFCNPJ()
     * @uses ClienteAcordoResponse::setChaveCliente()
     * @param \StructType\AssessoriaResponse $assessoria
     * @param string $cPFCNPJ
     * @param string $chaveCliente
     */
    public function __construct(\StructType\AssessoriaResponse $assessoria = null, $cPFCNPJ = null, $chaveCliente = null)
    {
        $this
            ->setAssessoria($assessoria)
            ->setCPFCNPJ($cPFCNPJ)
            ->setChaveCliente($chaveCliente);
    }
    /**
     * Get Assessoria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssessoriaResponse|null
     */
    public function getAssessoria()
    {
        return isset($this->Assessoria) ? $this->Assessoria : null;
    }
    /**
     * Set Assessoria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AssessoriaResponse $assessoria
     * @return \StructType\ClienteAcordoResponse
     */
    public function setAssessoria(\StructType\AssessoriaResponse $assessoria = null)
    {
        if (is_null($assessoria) || (is_array($assessoria) && empty($assessoria))) {
            unset($this->Assessoria);
        } else {
            $this->Assessoria = $assessoria;
        }
        return $this;
    }
    /**
     * Get CPFCNPJ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPFCNPJ()
    {
        return isset($this->CPFCNPJ) ? $this->CPFCNPJ : null;
    }
    /**
     * Set CPFCNPJ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPFCNPJ
     * @return \StructType\ClienteAcordoResponse
     */
    public function setCPFCNPJ($cPFCNPJ = null)
    {
        // validation for constraint: string
        if (!is_null($cPFCNPJ) && !is_string($cPFCNPJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPFCNPJ, true), gettype($cPFCNPJ)), __LINE__);
        }
        if (is_null($cPFCNPJ) || (is_array($cPFCNPJ) && empty($cPFCNPJ))) {
            unset($this->CPFCNPJ);
        } else {
            $this->CPFCNPJ = $cPFCNPJ;
        }
        return $this;
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\ClienteAcordoResponse
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
}
