<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculoPortal StructType
 * @subpackage Structs
 */
class CalculoPortal extends AbstractStructBase
{
    /**
     * The requisicaoCalculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ParcelaCalculoRequest
     */
    public $requisicaoCalculo;
    /**
     * The IdCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCliente;
    /**
     * The IdCredor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCredor;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for CalculoPortal
     * @uses CalculoPortal::setRequisicaoCalculo()
     * @uses CalculoPortal::setIdCliente()
     * @uses CalculoPortal::setIdCredor()
     * @uses CalculoPortal::setToken()
     * @param \StructType\ParcelaCalculoRequest $requisicaoCalculo
     * @param int $idCliente
     * @param int $idCredor
     * @param string $token
     */
    public function __construct(\StructType\ParcelaCalculoRequest $requisicaoCalculo = null, $idCliente = null, $idCredor = null, $token = null)
    {
        $this
            ->setRequisicaoCalculo($requisicaoCalculo)
            ->setIdCliente($idCliente)
            ->setIdCredor($idCredor)
            ->setToken($token);
    }
    /**
     * Get requisicaoCalculo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ParcelaCalculoRequest|null
     */
    public function getRequisicaoCalculo()
    {
        return isset($this->requisicaoCalculo) ? $this->requisicaoCalculo : null;
    }
    /**
     * Set requisicaoCalculo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ParcelaCalculoRequest $requisicaoCalculo
     * @return \StructType\CalculoPortal
     */
    public function setRequisicaoCalculo(\StructType\ParcelaCalculoRequest $requisicaoCalculo = null)
    {
        if (is_null($requisicaoCalculo) || (is_array($requisicaoCalculo) && empty($requisicaoCalculo))) {
            unset($this->requisicaoCalculo);
        } else {
            $this->requisicaoCalculo = $requisicaoCalculo;
        }
        return $this;
    }
    /**
     * Get IdCliente value
     * @return int|null
     */
    public function getIdCliente()
    {
        return $this->IdCliente;
    }
    /**
     * Set IdCliente value
     * @param int $idCliente
     * @return \StructType\CalculoPortal
     */
    public function setIdCliente($idCliente = null)
    {
        // validation for constraint: int
        if (!is_null($idCliente) && !(is_int($idCliente) || ctype_digit($idCliente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCliente, true), gettype($idCliente)), __LINE__);
        }
        $this->IdCliente = $idCliente;
        return $this;
    }
    /**
     * Get IdCredor value
     * @return int|null
     */
    public function getIdCredor()
    {
        return $this->IdCredor;
    }
    /**
     * Set IdCredor value
     * @param int $idCredor
     * @return \StructType\CalculoPortal
     */
    public function setIdCredor($idCredor = null)
    {
        // validation for constraint: int
        if (!is_null($idCredor) && !(is_int($idCredor) || ctype_digit($idCredor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCredor, true), gettype($idCredor)), __LINE__);
        }
        $this->IdCredor = $idCredor;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\CalculoPortal
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
