<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CadastraProposta StructType
 * @subpackage Structs
 */
class CadastraProposta extends AbstractStructBase
{
    /**
     * The propostaRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PropostaType
     */
    public $propostaRequest;
    /**
     * The IdCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCliente;
    /**
     * The IdCredor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCredor;
    /**
     * The IdPortalAcesso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdPortalAcesso;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for CadastraProposta
     * @uses CadastraProposta::setPropostaRequest()
     * @uses CadastraProposta::setIdCliente()
     * @uses CadastraProposta::setIdCredor()
     * @uses CadastraProposta::setIdPortalAcesso()
     * @uses CadastraProposta::setToken()
     * @param \StructType\PropostaType $propostaRequest
     * @param int $idCliente
     * @param int $idCredor
     * @param int $idPortalAcesso
     * @param string $token
     */
    public function __construct(\StructType\PropostaType $propostaRequest = null, $idCliente = null, $idCredor = null, $idPortalAcesso = null, $token = null)
    {
        $this
            ->setPropostaRequest($propostaRequest)
            ->setIdCliente($idCliente)
            ->setIdCredor($idCredor)
            ->setIdPortalAcesso($idPortalAcesso)
            ->setToken($token);
    }
    /**
     * Get propostaRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PropostaType|null
     */
    public function getPropostaRequest()
    {
        return isset($this->propostaRequest) ? $this->propostaRequest : null;
    }
    /**
     * Set propostaRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PropostaType $propostaRequest
     * @return \StructType\CadastraProposta
     */
    public function setPropostaRequest(\StructType\PropostaType $propostaRequest = null)
    {
        if (is_null($propostaRequest) || (is_array($propostaRequest) && empty($propostaRequest))) {
            unset($this->propostaRequest);
        } else {
            $this->propostaRequest = $propostaRequest;
        }
        return $this;
    }
    /**
     * Get IdCliente value
     * @return int|null
     */
    public function getIdCliente()
    {
        return $this->IdCliente;
    }
    /**
     * Set IdCliente value
     * @param int $idCliente
     * @return \StructType\CadastraProposta
     */
    public function setIdCliente($idCliente = null)
    {
        // validation for constraint: int
        if (!is_null($idCliente) && !(is_int($idCliente) || ctype_digit($idCliente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCliente, true), gettype($idCliente)), __LINE__);
        }
        $this->IdCliente = $idCliente;
        return $this;
    }
    /**
     * Get IdCredor value
     * @return int|null
     */
    public function getIdCredor()
    {
        return $this->IdCredor;
    }
    /**
     * Set IdCredor value
     * @param int $idCredor
     * @return \StructType\CadastraProposta
     */
    public function setIdCredor($idCredor = null)
    {
        // validation for constraint: int
        if (!is_null($idCredor) && !(is_int($idCredor) || ctype_digit($idCredor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCredor, true), gettype($idCredor)), __LINE__);
        }
        $this->IdCredor = $idCredor;
        return $this;
    }
    /**
     * Get IdPortalAcesso value
     * @return int|null
     */
    public function getIdPortalAcesso()
    {
        return $this->IdPortalAcesso;
    }
    /**
     * Set IdPortalAcesso value
     * @param int $idPortalAcesso
     * @return \StructType\CadastraProposta
     */
    public function setIdPortalAcesso($idPortalAcesso = null)
    {
        // validation for constraint: int
        if (!is_null($idPortalAcesso) && !(is_int($idPortalAcesso) || ctype_digit($idPortalAcesso))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPortalAcesso, true), gettype($idPortalAcesso)), __LINE__);
        }
        $this->IdPortalAcesso = $idPortalAcesso;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\CadastraProposta
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
