<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoletoRenegResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BoletoRenegResponse
 * @subpackage Structs
 */
class BoletoRenegResponse extends BoletoType
{
    /**
     * The Agencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Agencia;
    /**
     * The Banco
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Banco;
    /**
     * The Carteira
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Carteira;
    /**
     * The CodigoBarra
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoBarra;
    /**
     * The CodigoCedente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoCedente;
    /**
     * The ContaCorrente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaCorrente;
    /**
     * The DataDocumento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataDocumento;
    /**
     * The Instrucoes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Instrucoes;
    /**
     * The Juros
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Juros;
    /**
     * The LinhaDigitavel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LinhaDigitavel;
    /**
     * The Mensagens
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mensagens;
    /**
     * The Multa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Multa;
    /**
     * The NossoNumeroImpresso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NossoNumeroImpresso;
    /**
     * The NumeroAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroAcordo;
    /**
     * The NumeroDocumento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroDocumento;
    /**
     * The Taxa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Taxa;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Valor;
    /**
     * The ValorOriginal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorOriginal;
    /**
     * The Vencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vencimento;
    /**
     * The VencimentoOriginal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VencimentoOriginal;
    /**
     * Constructor method for BoletoRenegResponse
     * @uses BoletoRenegResponse::setAgencia()
     * @uses BoletoRenegResponse::setBanco()
     * @uses BoletoRenegResponse::setCarteira()
     * @uses BoletoRenegResponse::setCodigoBarra()
     * @uses BoletoRenegResponse::setCodigoCedente()
     * @uses BoletoRenegResponse::setContaCorrente()
     * @uses BoletoRenegResponse::setDataDocumento()
     * @uses BoletoRenegResponse::setInstrucoes()
     * @uses BoletoRenegResponse::setJuros()
     * @uses BoletoRenegResponse::setLinhaDigitavel()
     * @uses BoletoRenegResponse::setMensagens()
     * @uses BoletoRenegResponse::setMulta()
     * @uses BoletoRenegResponse::setNossoNumeroImpresso()
     * @uses BoletoRenegResponse::setNumeroAcordo()
     * @uses BoletoRenegResponse::setNumeroDocumento()
     * @uses BoletoRenegResponse::setTaxa()
     * @uses BoletoRenegResponse::setValor()
     * @uses BoletoRenegResponse::setValorOriginal()
     * @uses BoletoRenegResponse::setVencimento()
     * @uses BoletoRenegResponse::setVencimentoOriginal()
     * @param string $agencia
     * @param string $banco
     * @param string $carteira
     * @param string $codigoBarra
     * @param string $codigoCedente
     * @param string $contaCorrente
     * @param string $dataDocumento
     * @param string $instrucoes
     * @param float $juros
     * @param string $linhaDigitavel
     * @param string $mensagens
     * @param float $multa
     * @param string $nossoNumeroImpresso
     * @param int $numeroAcordo
     * @param string $numeroDocumento
     * @param float $taxa
     * @param float $valor
     * @param float $valorOriginal
     * @param string $vencimento
     * @param string $vencimentoOriginal
     */
    public function __construct($agencia = null, $banco = null, $carteira = null, $codigoBarra = null, $codigoCedente = null, $contaCorrente = null, $dataDocumento = null, $instrucoes = null, $juros = null, $linhaDigitavel = null, $mensagens = null, $multa = null, $nossoNumeroImpresso = null, $numeroAcordo = null, $numeroDocumento = null, $taxa = null, $valor = null, $valorOriginal = null, $vencimento = null, $vencimentoOriginal = null)
    {
        $this
            ->setAgencia($agencia)
            ->setBanco($banco)
            ->setCarteira($carteira)
            ->setCodigoBarra($codigoBarra)
            ->setCodigoCedente($codigoCedente)
            ->setContaCorrente($contaCorrente)
            ->setDataDocumento($dataDocumento)
            ->setInstrucoes($instrucoes)
            ->setJuros($juros)
            ->setLinhaDigitavel($linhaDigitavel)
            ->setMensagens($mensagens)
            ->setMulta($multa)
            ->setNossoNumeroImpresso($nossoNumeroImpresso)
            ->setNumeroAcordo($numeroAcordo)
            ->setNumeroDocumento($numeroDocumento)
            ->setTaxa($taxa)
            ->setValor($valor)
            ->setValorOriginal($valorOriginal)
            ->setVencimento($vencimento)
            ->setVencimentoOriginal($vencimentoOriginal);
    }
    /**
     * Get Agencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencia()
    {
        return isset($this->Agencia) ? $this->Agencia : null;
    }
    /**
     * Set Agencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencia
     * @return \StructType\BoletoRenegResponse
     */
    public function setAgencia($agencia = null)
    {
        // validation for constraint: string
        if (!is_null($agencia) && !is_string($agencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencia, true), gettype($agencia)), __LINE__);
        }
        if (is_null($agencia) || (is_array($agencia) && empty($agencia))) {
            unset($this->Agencia);
        } else {
            $this->Agencia = $agencia;
        }
        return $this;
    }
    /**
     * Get Banco value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBanco()
    {
        return isset($this->Banco) ? $this->Banco : null;
    }
    /**
     * Set Banco value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $banco
     * @return \StructType\BoletoRenegResponse
     */
    public function setBanco($banco = null)
    {
        // validation for constraint: string
        if (!is_null($banco) && !is_string($banco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($banco, true), gettype($banco)), __LINE__);
        }
        if (is_null($banco) || (is_array($banco) && empty($banco))) {
            unset($this->Banco);
        } else {
            $this->Banco = $banco;
        }
        return $this;
    }
    /**
     * Get Carteira value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarteira()
    {
        return isset($this->Carteira) ? $this->Carteira : null;
    }
    /**
     * Set Carteira value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carteira
     * @return \StructType\BoletoRenegResponse
     */
    public function setCarteira($carteira = null)
    {
        // validation for constraint: string
        if (!is_null($carteira) && !is_string($carteira)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carteira, true), gettype($carteira)), __LINE__);
        }
        if (is_null($carteira) || (is_array($carteira) && empty($carteira))) {
            unset($this->Carteira);
        } else {
            $this->Carteira = $carteira;
        }
        return $this;
    }
    /**
     * Get CodigoBarra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoBarra()
    {
        return isset($this->CodigoBarra) ? $this->CodigoBarra : null;
    }
    /**
     * Set CodigoBarra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoBarra
     * @return \StructType\BoletoRenegResponse
     */
    public function setCodigoBarra($codigoBarra = null)
    {
        // validation for constraint: string
        if (!is_null($codigoBarra) && !is_string($codigoBarra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoBarra, true), gettype($codigoBarra)), __LINE__);
        }
        if (is_null($codigoBarra) || (is_array($codigoBarra) && empty($codigoBarra))) {
            unset($this->CodigoBarra);
        } else {
            $this->CodigoBarra = $codigoBarra;
        }
        return $this;
    }
    /**
     * Get CodigoCedente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoCedente()
    {
        return isset($this->CodigoCedente) ? $this->CodigoCedente : null;
    }
    /**
     * Set CodigoCedente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoCedente
     * @return \StructType\BoletoRenegResponse
     */
    public function setCodigoCedente($codigoCedente = null)
    {
        // validation for constraint: string
        if (!is_null($codigoCedente) && !is_string($codigoCedente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoCedente, true), gettype($codigoCedente)), __LINE__);
        }
        if (is_null($codigoCedente) || (is_array($codigoCedente) && empty($codigoCedente))) {
            unset($this->CodigoCedente);
        } else {
            $this->CodigoCedente = $codigoCedente;
        }
        return $this;
    }
    /**
     * Get ContaCorrente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaCorrente()
    {
        return isset($this->ContaCorrente) ? $this->ContaCorrente : null;
    }
    /**
     * Set ContaCorrente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaCorrente
     * @return \StructType\BoletoRenegResponse
     */
    public function setContaCorrente($contaCorrente = null)
    {
        // validation for constraint: string
        if (!is_null($contaCorrente) && !is_string($contaCorrente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contaCorrente, true), gettype($contaCorrente)), __LINE__);
        }
        if (is_null($contaCorrente) || (is_array($contaCorrente) && empty($contaCorrente))) {
            unset($this->ContaCorrente);
        } else {
            $this->ContaCorrente = $contaCorrente;
        }
        return $this;
    }
    /**
     * Get DataDocumento value
     * @return string|null
     */
    public function getDataDocumento()
    {
        return $this->DataDocumento;
    }
    /**
     * Set DataDocumento value
     * @param string $dataDocumento
     * @return \StructType\BoletoRenegResponse
     */
    public function setDataDocumento($dataDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($dataDocumento) && !is_string($dataDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataDocumento, true), gettype($dataDocumento)), __LINE__);
        }
        $this->DataDocumento = $dataDocumento;
        return $this;
    }
    /**
     * Get Instrucoes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstrucoes()
    {
        return isset($this->Instrucoes) ? $this->Instrucoes : null;
    }
    /**
     * Set Instrucoes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instrucoes
     * @return \StructType\BoletoRenegResponse
     */
    public function setInstrucoes($instrucoes = null)
    {
        // validation for constraint: string
        if (!is_null($instrucoes) && !is_string($instrucoes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instrucoes, true), gettype($instrucoes)), __LINE__);
        }
        if (is_null($instrucoes) || (is_array($instrucoes) && empty($instrucoes))) {
            unset($this->Instrucoes);
        } else {
            $this->Instrucoes = $instrucoes;
        }
        return $this;
    }
    /**
     * Get Juros value
     * @return float|null
     */
    public function getJuros()
    {
        return $this->Juros;
    }
    /**
     * Set Juros value
     * @param float $juros
     * @return \StructType\BoletoRenegResponse
     */
    public function setJuros($juros = null)
    {
        // validation for constraint: float
        if (!is_null($juros) && !(is_float($juros) || is_numeric($juros))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($juros, true), gettype($juros)), __LINE__);
        }
        $this->Juros = $juros;
        return $this;
    }
    /**
     * Get LinhaDigitavel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinhaDigitavel()
    {
        return isset($this->LinhaDigitavel) ? $this->LinhaDigitavel : null;
    }
    /**
     * Set LinhaDigitavel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linhaDigitavel
     * @return \StructType\BoletoRenegResponse
     */
    public function setLinhaDigitavel($linhaDigitavel = null)
    {
        // validation for constraint: string
        if (!is_null($linhaDigitavel) && !is_string($linhaDigitavel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linhaDigitavel, true), gettype($linhaDigitavel)), __LINE__);
        }
        if (is_null($linhaDigitavel) || (is_array($linhaDigitavel) && empty($linhaDigitavel))) {
            unset($this->LinhaDigitavel);
        } else {
            $this->LinhaDigitavel = $linhaDigitavel;
        }
        return $this;
    }
    /**
     * Get Mensagens value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMensagens()
    {
        return isset($this->Mensagens) ? $this->Mensagens : null;
    }
    /**
     * Set Mensagens value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mensagens
     * @return \StructType\BoletoRenegResponse
     */
    public function setMensagens($mensagens = null)
    {
        // validation for constraint: string
        if (!is_null($mensagens) && !is_string($mensagens)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensagens, true), gettype($mensagens)), __LINE__);
        }
        if (is_null($mensagens) || (is_array($mensagens) && empty($mensagens))) {
            unset($this->Mensagens);
        } else {
            $this->Mensagens = $mensagens;
        }
        return $this;
    }
    /**
     * Get Multa value
     * @return float|null
     */
    public function getMulta()
    {
        return $this->Multa;
    }
    /**
     * Set Multa value
     * @param float $multa
     * @return \StructType\BoletoRenegResponse
     */
    public function setMulta($multa = null)
    {
        // validation for constraint: float
        if (!is_null($multa) && !(is_float($multa) || is_numeric($multa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($multa, true), gettype($multa)), __LINE__);
        }
        $this->Multa = $multa;
        return $this;
    }
    /**
     * Get NossoNumeroImpresso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNossoNumeroImpresso()
    {
        return isset($this->NossoNumeroImpresso) ? $this->NossoNumeroImpresso : null;
    }
    /**
     * Set NossoNumeroImpresso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nossoNumeroImpresso
     * @return \StructType\BoletoRenegResponse
     */
    public function setNossoNumeroImpresso($nossoNumeroImpresso = null)
    {
        // validation for constraint: string
        if (!is_null($nossoNumeroImpresso) && !is_string($nossoNumeroImpresso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nossoNumeroImpresso, true), gettype($nossoNumeroImpresso)), __LINE__);
        }
        if (is_null($nossoNumeroImpresso) || (is_array($nossoNumeroImpresso) && empty($nossoNumeroImpresso))) {
            unset($this->NossoNumeroImpresso);
        } else {
            $this->NossoNumeroImpresso = $nossoNumeroImpresso;
        }
        return $this;
    }
    /**
     * Get NumeroAcordo value
     * @return int|null
     */
    public function getNumeroAcordo()
    {
        return $this->NumeroAcordo;
    }
    /**
     * Set NumeroAcordo value
     * @param int $numeroAcordo
     * @return \StructType\BoletoRenegResponse
     */
    public function setNumeroAcordo($numeroAcordo = null)
    {
        // validation for constraint: int
        if (!is_null($numeroAcordo) && !(is_int($numeroAcordo) || ctype_digit($numeroAcordo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroAcordo, true), gettype($numeroAcordo)), __LINE__);
        }
        $this->NumeroAcordo = $numeroAcordo;
        return $this;
    }
    /**
     * Get NumeroDocumento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroDocumento()
    {
        return isset($this->NumeroDocumento) ? $this->NumeroDocumento : null;
    }
    /**
     * Set NumeroDocumento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroDocumento
     * @return \StructType\BoletoRenegResponse
     */
    public function setNumeroDocumento($numeroDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDocumento) && !is_string($numeroDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDocumento, true), gettype($numeroDocumento)), __LINE__);
        }
        if (is_null($numeroDocumento) || (is_array($numeroDocumento) && empty($numeroDocumento))) {
            unset($this->NumeroDocumento);
        } else {
            $this->NumeroDocumento = $numeroDocumento;
        }
        return $this;
    }
    /**
     * Get Taxa value
     * @return float|null
     */
    public function getTaxa()
    {
        return $this->Taxa;
    }
    /**
     * Set Taxa value
     * @param float $taxa
     * @return \StructType\BoletoRenegResponse
     */
    public function setTaxa($taxa = null)
    {
        // validation for constraint: float
        if (!is_null($taxa) && !(is_float($taxa) || is_numeric($taxa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxa, true), gettype($taxa)), __LINE__);
        }
        $this->Taxa = $taxa;
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\BoletoRenegResponse
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get ValorOriginal value
     * @return float|null
     */
    public function getValorOriginal()
    {
        return $this->ValorOriginal;
    }
    /**
     * Set ValorOriginal value
     * @param float $valorOriginal
     * @return \StructType\BoletoRenegResponse
     */
    public function setValorOriginal($valorOriginal = null)
    {
        // validation for constraint: float
        if (!is_null($valorOriginal) && !(is_float($valorOriginal) || is_numeric($valorOriginal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorOriginal, true), gettype($valorOriginal)), __LINE__);
        }
        $this->ValorOriginal = $valorOriginal;
        return $this;
    }
    /**
     * Get Vencimento value
     * @return string|null
     */
    public function getVencimento()
    {
        return $this->Vencimento;
    }
    /**
     * Set Vencimento value
     * @param string $vencimento
     * @return \StructType\BoletoRenegResponse
     */
    public function setVencimento($vencimento = null)
    {
        // validation for constraint: string
        if (!is_null($vencimento) && !is_string($vencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimento, true), gettype($vencimento)), __LINE__);
        }
        $this->Vencimento = $vencimento;
        return $this;
    }
    /**
     * Get VencimentoOriginal value
     * @return string|null
     */
    public function getVencimentoOriginal()
    {
        return $this->VencimentoOriginal;
    }
    /**
     * Set VencimentoOriginal value
     * @param string $vencimentoOriginal
     * @return \StructType\BoletoRenegResponse
     */
    public function setVencimentoOriginal($vencimentoOriginal = null)
    {
        // validation for constraint: string
        if (!is_null($vencimentoOriginal) && !is_string($vencimentoOriginal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimentoOriginal, true), gettype($vencimentoOriginal)), __LINE__);
        }
        $this->VencimentoOriginal = $vencimentoOriginal;
        return $this;
    }
}
