<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlterarNumeroAcordo StructType
 * @subpackage Structs
 */
class AlterarNumeroAcordo extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The NumeroAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroAcordo;
    /**
     * The NovoNumero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NovoNumero;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for AlterarNumeroAcordo
     * @uses AlterarNumeroAcordo::setChaveCliente()
     * @uses AlterarNumeroAcordo::setNumeroAcordo()
     * @uses AlterarNumeroAcordo::setNovoNumero()
     * @uses AlterarNumeroAcordo::setToken()
     * @param string $chaveCliente
     * @param int $numeroAcordo
     * @param string $novoNumero
     * @param string $token
     */
    public function __construct($chaveCliente = null, $numeroAcordo = null, $novoNumero = null, $token = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setNumeroAcordo($numeroAcordo)
            ->setNovoNumero($novoNumero)
            ->setToken($token);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\AlterarNumeroAcordo
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get NumeroAcordo value
     * @return int|null
     */
    public function getNumeroAcordo()
    {
        return $this->NumeroAcordo;
    }
    /**
     * Set NumeroAcordo value
     * @param int $numeroAcordo
     * @return \StructType\AlterarNumeroAcordo
     */
    public function setNumeroAcordo($numeroAcordo = null)
    {
        // validation for constraint: int
        if (!is_null($numeroAcordo) && !(is_int($numeroAcordo) || ctype_digit($numeroAcordo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroAcordo, true), gettype($numeroAcordo)), __LINE__);
        }
        $this->NumeroAcordo = $numeroAcordo;
        return $this;
    }
    /**
     * Get NovoNumero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNovoNumero()
    {
        return isset($this->NovoNumero) ? $this->NovoNumero : null;
    }
    /**
     * Set NovoNumero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $novoNumero
     * @return \StructType\AlterarNumeroAcordo
     */
    public function setNovoNumero($novoNumero = null)
    {
        // validation for constraint: string
        if (!is_null($novoNumero) && !is_string($novoNumero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($novoNumero, true), gettype($novoNumero)), __LINE__);
        }
        if (is_null($novoNumero) || (is_array($novoNumero) && empty($novoNumero))) {
            unset($this->NovoNumero);
        } else {
            $this->NovoNumero = $novoNumero;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\AlterarNumeroAcordo
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
