<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Suspender ServiceType
 * @subpackage Services
 */
class Suspender extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SuspenderCobranca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SuspenderCobranca $parameters
     * @return \StructType\SuspenderCobrancaResponse|bool
     */
    public function SuspenderCobranca(\StructType\SuspenderCobranca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SuspenderCobranca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SuspenderCobrancaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
