<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Salvar ServiceType
 * @subpackage Services
 */
class Salvar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SalvarPagamentoCheckout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SalvarPagamentoCheckout $parameters
     * @return \StructType\SalvarPagamentoCheckoutResponse|bool
     */
    public function SalvarPagamentoCheckout(\StructType\SalvarPagamentoCheckout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvarPagamentoCheckout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SalvarPagamentoPreTransacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SalvarPagamentoPreTransacao $parameters
     * @return \StructType\SalvarPagamentoPreTransacaoResponse|bool
     */
    public function SalvarPagamentoPreTransacao(\StructType\SalvarPagamentoPreTransacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvarPagamentoPreTransacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SalvarEventoRecusadoCheckout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SalvarEventoRecusadoCheckout $parameters
     * @return \StructType\SalvarEventoRecusadoCheckoutResponse|bool
     */
    public function SalvarEventoRecusadoCheckout(\StructType\SalvarEventoRecusadoCheckout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvarEventoRecusadoCheckout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SalvarCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SalvarCliente $parameters
     * @return \StructType\SalvarClienteResponse|bool
     */
    public function SalvarCliente(\StructType\SalvarCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvarCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SalvarAcordo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SalvarAcordo $parameters
     * @return \StructType\SalvarAcordoResponse|bool
     */
    public function SalvarAcordo(\StructType\SalvarAcordo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvarAcordo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SalvarAcordoResponse|\StructType\SalvarClienteResponse|\StructType\SalvarEventoRecusadoCheckoutResponse|\StructType\SalvarPagamentoCheckoutResponse|\StructType\SalvarPagamentoPreTransacaoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
