<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Remover ServiceType
 * @subpackage Services
 */
class Remover extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RemoverSPC
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RemoverSPC $parameters
     * @return \StructType\RemoverSPCResponse|bool
     */
    public function RemoverSPC(\StructType\RemoverSPC $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RemoverSPC($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RemoverSPCResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
