<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reativar ServiceType
 * @subpackage Services
 */
class Reativar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReativarCobranca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReativarCobranca $parameters
     * @return \StructType\ReativarCobrancaResponse|bool
     */
    public function ReativarCobranca(\StructType\ReativarCobranca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReativarCobranca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReativarCobrancaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
