<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pagar ServiceType
 * @subpackage Services
 */
class Pagar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PagarAcordoPorParcela
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagarAcordoPorParcela $parameters
     * @return \StructType\PagarAcordoPorParcelaResponse|bool
     */
    public function PagarAcordoPorParcela(\StructType\PagarAcordoPorParcela $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagarAcordoPorParcela($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PagarAcordo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PagarAcordo $parameters
     * @return \StructType\PagarAcordoResponse|bool
     */
    public function PagarAcordo(\StructType\PagarAcordo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PagarAcordo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PagarAcordoPorParcelaResponse|\StructType\PagarAcordoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
