<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Login ServiceType
 * @subpackage Services
 */
class Login extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LoginPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoginPortal $parameters
     * @return \StructType\LoginPortalResponse|bool
     */
    public function LoginPortal(\StructType\LoginPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoginPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoginRedirect
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoginRedirect $parameters
     * @return \StructType\LoginRedirectResponse|bool
     */
    public function LoginRedirect(\StructType\LoginRedirect $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoginRedirect($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoginCobChat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\LoginCobChat $parameters
     * @return \StructType\LoginCobChatResponse|bool
     */
    public function LoginCobChat(\StructType\LoginCobChat $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->LoginCobChat($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\LoginCobChatResponse|\StructType\LoginPortalResponse|\StructType\LoginRedirectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
